/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.parts;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.parts.PanelButton;
import de.willuhn.jameica.gui.util.Font;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class TitlePart
implements Part {
    private static final Font FONT = Font.H2;
    private static final int TITLE_OFFSET_X = 8;
    private static final int TITLE_OFFSET_Y = 8;
    private Composite myParent = null;
    private Canvas title = null;
    private String titleText = null;
    private boolean border = true;
    private Composite panelButtons = null;
    private List<PanelButton> buttons = new LinkedList<PanelButton>();

    public TitlePart(String title) {
        this(title, true);
    }

    public TitlePart(String title, boolean border) {
        this.titleText = title;
        this.border = border;
    }

    public void setTitle(String text) {
        this.titleText = text;
        if (this.title != null) {
            GUI.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (TitlePart.this.title.isDisposed()) {
                        return;
                    }
                    TitlePart.this.title.redraw();
                }
            });
        }
    }

    public void addButton(PanelButton b) {
        this.buttons.add(b);
        this.updateButtons();
    }

    public void clearButtons() {
        for (PanelButton b : this.buttons) {
            try {
                Composite c = (Composite)b.getControl();
                if (c == null || c.isDisposed()) {
                    return;
                }
                SWTUtil.disposeChildren(c);
                c.dispose();
            }
            catch (Exception e) {
                Logger.error((String)"error while disposing panel-button", (Throwable)e);
            }
        }
        this.buttons.clear();
    }

    @Override
    public void paint(Composite parent) {
        if (this.myParent != null) {
            return;
        }
        Image image = SWTUtil.getImage("panelbar.png");
        int imageHeight = image.getBounds().height;
        int fontHeight = Font.getHeight(FONT) + 16;
        int height = Math.max(imageHeight, fontHeight);
        this.myParent = new Composite(parent, this.border ? 2048 : 0);
        this.myParent.setLayout((Layout)SWTUtil.createGrid(1, false));
        this.myParent.setLayoutData((Object)new GridData(1808));
        Composite head = new Composite(this.myParent, 0);
        head.setLayout((Layout)SWTUtil.createGrid(2, false));
        GridData gd = new GridData(768);
        gd.heightHint = height;
        head.setLayoutData((Object)gd);
        this.title = SWTUtil.getCanvas(head, image, 147456);
        this.title.setBackground(GUI.getDisplay().getSystemColor(25));
        this.title.setLayout((Layout)SWTUtil.createGrid(1, false));
        gd = new GridData(768);
        gd.heightHint = height;
        this.title.setLayoutData((Object)gd);
        this.title.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                GC gc = event.gc;
                gc.setFont(FONT.getSWTFont());
                gc.setBackground(GUI.getDisplay().getSystemColor(0x40000000));
                int osx = 8;
                int osy = 4;
                int os = Application.getPlatform().getOS();
                if (os != 2 && os != 5) {
                    osx = SWTUtil.scaledPx(osx);
                    osy = SWTUtil.scaledPx(osy);
                }
                gc.drawText(TitlePart.this.titleText == null ? "" : TitlePart.this.titleText, osx, osy, true);
            }
        });
        this.panelButtons = new Composite(head, 0);
        gd = new GridData();
        gd.heightHint = height;
        gd.widthHint = 0;
        this.panelButtons.setLayoutData((Object)gd);
        Label sep = new Label(this.myParent, 258);
        sep.setLayoutData((Object)new GridData(768));
        this.updateButtons();
    }

    private void updateButtons() {
        if (this.panelButtons == null || this.panelButtons.isDisposed()) {
            return;
        }
        GUI.getDisplay().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (TitlePart.this.panelButtons.isDisposed()) {
                    return;
                }
                try {
                    TitlePart.this.panelButtons.setVisible(false);
                    int size = TitlePart.this.buttons.size();
                    SWTUtil.disposeChildren(TitlePart.this.panelButtons);
                    TitlePart.this.panelButtons.setLayout((Layout)SWTUtil.createGrid(size, false));
                    Image background = SWTUtil.getImage("panelbar-button-default.png");
                    GridData gd = (GridData)TitlePart.this.panelButtons.getLayoutData();
                    gd.widthHint = background.getBounds().width * size;
                    for (int i = size - 1; i >= 0; --i) {
                        TitlePart.this.buttons.get(i).paint(TitlePart.this.panelButtons);
                    }
                    TitlePart.this.panelButtons.getParent().layout();
                    TitlePart.this.panelButtons.layout();
                }
                catch (Exception e) {
                    Logger.error((String)"unable to paint panel buttons", (Throwable)e);
                }
                finally {
                    TitlePart.this.panelButtons.setVisible(true);
                }
            }
        });
    }

    public Composite getComposite() {
        return this.myParent;
    }
}

