/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.parts;

import de.willuhn.io.IOUtil;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.Font;
import de.willuhn.jameica.system.Application;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.rmi.RemoteException;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class TextPart
implements Part {
    private StringBuffer content = new StringBuffer();
    private boolean wrap = true;
    private StyledText stext = null;
    private Color background = null;
    private boolean autoscroll = false;

    public TextPart(String text) {
        this.content = new StringBuffer(text);
    }

    public TextPart() {
        this.content = new StringBuffer();
    }

    public TextPart(File text) throws IOException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(text));
            String thisLine = null;
            StringBuffer buffer = new StringBuffer();
            while ((thisLine = br.readLine()) != null) {
                buffer.append(thisLine + "\n");
            }
            this.content = buffer;
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                IOUtil.close((Closeable[])new Closeable[]{br});
                throw throwable;
            }
        }
        IOUtil.close((Closeable[])new Closeable[]{br});
    }

    public void setAutoscroll(boolean b) {
        this.autoscroll = b;
    }

    public void setWordWrap(boolean wrap) {
        this.wrap = wrap;
    }

    public void appendText(String text, Color color) {
        if (text == null || ((String)text).length() == 0) {
            return;
        }
        if (!((String)text).endsWith("\n")) {
            text = (String)text + "\n";
        }
        if (this.stext == null || this.stext.isDisposed()) {
            this.content.append((String)text);
            return;
        }
        if (color != null) {
            this.stext.setForeground(color.getSWTColor());
        }
        this.stext.append((String)text);
        this.scroll();
        if (color != null) {
            this.stext.setForeground(Color.FOREGROUND.getSWTColor());
        }
    }

    public void appendText(String text) {
        this.appendText(text, null);
    }

    public void clear() {
        this.content = new StringBuffer();
        GUI.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (TextPart.this.stext == null || TextPart.this.stext.isDisposed()) {
                    return;
                }
                TextPart.this.stext.setText("");
            }
        });
    }

    private void scroll() {
        if (this.stext == null || this.stext.isDisposed()) {
            return;
        }
        if (this.autoscroll) {
            this.stext.setTopIndex(this.stext.getLineCount());
        }
    }

    @Override
    public void paint(Composite parent) throws RemoteException {
        this.stext = new StyledText(parent, 520);
        this.stext.setFont(Font.DEFAULT.getSWTFont());
        if (this.background != null) {
            this.stext.setBackground(this.background.getSWTColor());
        }
        this.stext.setEditable(false);
        this.stext.setWordWrap(this.wrap);
        this.stext.setLayoutData((Object)new GridData(1808));
        if (this.content != null) {
            this.stext.append(this.content.toString());
        }
        final int mod = Application.getPlatform().getOS() == 3 ? 0x400000 : 262144;
        this.stext.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (TextPart.this.stext.isDisposed()) {
                    return;
                }
                if (!TextPart.this.stext.isDisposed() && e.stateMask == mod && e.keyCode == 97) {
                    TextPart.this.stext.selectAll();
                    e.doit = false;
                }
            }
        });
        this.scroll();
    }

    public void setBackground(Color color) {
        if (color == null) {
            return;
        }
        this.background = color;
        if (this.stext != null && !this.stext.isDisposed()) {
            this.stext.setBackground(this.background.getSWTColor());
        }
    }
}

