/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.parts;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.rmi.DBObject;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.formatter.TableFormatter;
import de.willuhn.jameica.gui.parts.AbstractTablePart;
import de.willuhn.jameica.gui.parts.Column;
import de.willuhn.jameica.gui.parts.TableChangeListener;
import de.willuhn.jameica.gui.parts.table.Feature;
import de.willuhn.jameica.gui.parts.table.FeatureSummary;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.security.Checksum;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.Session;
import java.lang.reflect.Array;
import java.rmi.RemoteException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class TablePart
extends AbstractTablePart {
    private I18N i18n = null;
    private String id = null;
    private List temp = null;
    private Table table = null;
    protected TableFormatter tableFormatter = null;
    private Composite comp = null;
    private Image up = null;
    private Image down = null;
    private TableEditor editor = null;
    private de.willuhn.datasource.rmi.Listener deleteListener = new DeleteListener();
    private List<TableChangeListener> changeListeners = new ArrayList<TableChangeListener>();
    private Map<Integer, List<Item>> sortTable = new HashMap<Integer, List<Item>>();
    private Map<Object, String[]> textTable = new HashMap<Object, String[]>();
    private int sortedBy = -1;
    private boolean direction = true;
    private boolean enabled = true;
    private static Session state = new Session();
    private Collator collator = null;

    public TablePart(Action action) {
        this((List)null, action);
    }

    public TablePart(GenericIterator list, Action action) {
        this(TablePart.asList(list), action);
    }

    public TablePart(List list, Action action) {
        super(action);
        this.addFeature(new FeatureSummary());
        this.temp = new ArrayList();
        if (list != null) {
            this.temp.addAll(list);
        }
        this.i18n = Application.getI18n();
        this.up = SWTUtil.getImage("up.png");
        this.down = SWTUtil.getImage("down.png");
    }

    public void setFormatter(TableFormatter formatter) {
        this.tableFormatter = formatter;
    }

    public void addChangeListener(TableChangeListener l) {
        if (l != null) {
            this.changeListeners.add(l);
        }
    }

    @Deprecated
    public void setSummary(boolean show) {
        if (show) {
            this.addFeature(new FeatureSummary());
        } else {
            this.removeFeature(FeatureSummary.class);
        }
    }

    @Override
    public List getItems() throws RemoteException {
        return this.getItems(true);
    }

    public List getItems(boolean onlyChecked) throws RemoteException {
        ArrayList<Object> l = new ArrayList<Object>();
        if (this.table == null || this.table.isDisposed()) {
            l.addAll(this.temp);
            return l;
        }
        TableItem[] items = this.table.getItems();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || items[i].isDisposed() || onlyChecked && this.checkable && !items[i].getChecked()) continue;
            l.add(items[i].getData());
        }
        return l;
    }

    public void setTopIndex(int i) {
        if (this.table == null) {
            return;
        }
        this.table.setTopIndex(i);
    }

    @Override
    public void removeAll() {
        if (this.table != null && !this.table.isDisposed()) {
            this.table.removeAll();
        }
        this.temp.clear();
        this.sortTable.clear();
        this.textTable.clear();
        this.featureEvent(Feature.Event.REMOVED_ALL, null);
    }

    public int removeItem(Object item) {
        if (item == null) {
            return -1;
        }
        Object o = null;
        if (this.table == null || this.table.isDisposed()) {
            int size = this.temp.size();
            for (int i = 0; i < size; ++i) {
                o = this.temp.get(i);
                try {
                    if (!BeanUtil.equals(o, (Object)item)) continue;
                    this.temp.remove(i);
                    return i;
                }
                catch (Exception e) {
                    Logger.error((String)"unable to remove object", (Throwable)e);
                }
            }
            return -1;
        }
        TableItem[] items = this.table.getItems();
        for (int i = 0; i < items.length; ++i) {
            try {
                o = items[i].getData();
                if (!BeanUtil.equals((Object)o, (Object)item)) continue;
                if (Application.inStandaloneMode() && o instanceof DBObject) {
                    try {
                        ((DBObject)o).removeDeleteListener(this.deleteListener);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                for (List<Item> l : this.sortTable.values()) {
                    l.remove(new Item(item, null));
                }
                this.table.remove(i);
                this.featureEvent(Feature.Event.REMOVED, item);
                return i;
            }
            catch (Throwable t) {
                Logger.error((String)"error while removing item", (Throwable)t);
            }
        }
        return -1;
    }

    public void addItem(Object object) throws RemoteException {
        this.addItem(object, this.size());
    }

    public void addItem(Object object, boolean checked) throws RemoteException {
        this.addItem(object, this.size(), checked);
    }

    public void addItem(Object object, int index) throws RemoteException {
        this.addItem(object, index, true);
    }

    public void updateItem(Object oldVersion, Object newVersion) throws RemoteException {
        if (this.table == null || this.table.isDisposed() || oldVersion == null || newVersion == null) {
            return;
        }
        try {
            for (TableItem item : this.table.getItems()) {
                Object current = item.getData();
                if (!BeanUtil.equals((Object)current, (Object)oldVersion)) continue;
                item.setData(newVersion);
                String[] text = new String[this.columns.size()];
                for (int i = 0; i < this.columns.size(); ++i) {
                    Column col = (Column)this.columns.get(i);
                    List<Item> l = this.sortTable.get(i);
                    int pos = l.indexOf(new Item(oldVersion, null));
                    if (pos < 0) {
                        Logger.warn((String)"unable to find sort entry in table, skipping update");
                        return;
                    }
                    Item di = l.get(pos);
                    di.data = newVersion;
                    di.update();
                    String display = col.getFormattedValue(di.value, di.data);
                    item.setText(i, display);
                    text[i] = display;
                }
                this.textTable.remove(oldVersion);
                this.textTable.put(newVersion, text);
                if (this.tableFormatter != null) {
                    this.tableFormatter.format(item);
                }
                return;
            }
        }
        catch (Exception e) {
            Logger.error((String)"error updating item", (Throwable)e);
        }
    }

    public void addItem(Object object, int index, boolean checked) throws RemoteException {
        if (this.table == null || this.table.isDisposed()) {
            this.temp.add(index, object);
            return;
        }
        TableItem item = new TableItem(this.table, 0, index);
        if (this.checkable) {
            item.setChecked(checked);
        }
        if (Application.inStandaloneMode() && object instanceof DBObject) {
            try {
                ((DBObject)object).removeDeleteListener(this.deleteListener);
                ((DBObject)object).addDeleteListener(this.deleteListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        item.setData(object);
        String[] text = new String[this.columns.size()];
        for (int i = 0; i < this.columns.size(); ++i) {
            Column col = (Column)this.columns.get(i);
            Item di = new Item(object, col);
            String display = col.getFormattedValue(di.value, di.data);
            item.setText(i, display);
            text[i] = display;
            List<Item> l = this.sortTable.get(i);
            if (l == null) {
                l = new LinkedList<Item>();
                this.sortTable.put(i, l);
            }
            l.add(di);
        }
        this.textTable.put(object, text);
        if (this.tableFormatter != null) {
            this.tableFormatter.format(item);
        }
        this.featureEvent(Feature.Event.ADDED, object);
    }

    @Override
    public int size() {
        if (this.table == null || this.table.isDisposed()) {
            return this.temp.size();
        }
        return this.table.getItemCount();
    }

    @Override
    public synchronized void paint(Composite parent) throws RemoteException {
        int[] colOrder;
        TableColumn col;
        int i;
        if (this.comp != null && !this.comp.isDisposed()) {
            this.comp.dispose();
        }
        this.comp = new Composite(parent, 0);
        GridData gridData = new GridData(1808);
        this.comp.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.comp.setLayout((Layout)layout);
        int flags = (this.multi ? 2 : 4) | 0x100 | 0x200 | 0x10000;
        if (this.checkable) {
            flags |= 0x20;
        }
        this.table = GUI.getStyleFactory().createTable(this.comp, flags);
        this.table.setLayoutData((Object)new GridData(1808));
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setEnabled(this.enabled);
        if (this.rememberOrder) {
            this.table.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    try {
                        TablePart.this.setColumnOrder(TablePart.this.table.getColumnOrder());
                        Object s = TablePart.this.getOrderedBy();
                        if (s == null) {
                            return;
                        }
                        if (!TablePart.this.direction) {
                            s = "!" + (String)s;
                        }
                        Logger.debug((String)("saving table order: " + (String)s));
                        AbstractTablePart.settings.setAttribute("order." + TablePart.this.getID(), (String)s);
                    }
                    catch (Exception ex) {
                        Logger.error((String)"unable to store last order", (Throwable)ex);
                    }
                }
            });
        }
        Object test = this.temp.size() > 0 ? this.temp.get(0) : null;
        for (i = 0; i < this.columns.size(); ++i) {
            Object value;
            Column column = (Column)this.columns.get(i);
            col = new TableColumn(this.table, 0);
            column.setColumn((org.eclipse.swt.widgets.Item)col);
            col.setMoveable(true);
            col.setText(column.getName() == null ? "" : column.getName());
            if (this.rememberColWidth) {
                final int index = i;
                col.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        try {
                            if (col == null || col.isDisposed()) {
                                return;
                            }
                            AbstractTablePart.settings.setAttribute("width." + TablePart.this.getID() + "." + index, col.getWidth());
                        }
                        catch (Exception ex) {
                            Logger.error((String)("unable to store width for column " + index), (Throwable)ex);
                        }
                    }
                });
            }
            final int p = i;
            col.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    TablePart.this.direction = !TablePart.this.direction || p != TablePart.this.sortedBy;
                    TablePart.this.orderBy(p);
                }
            });
            if (column.getAlign() != -1) {
                col.setAlignment(column.getAlign());
                continue;
            }
            if (test == null || !((value = BeanUtil.get(test, (String)column.getColumnId())) instanceof Number)) continue;
            col.setAlignment(131072);
        }
        if (this.rememberOrder && (colOrder = this.getColumnOrder()) != null) {
            this.table.setColumnOrder(colOrder);
        }
        for (i = 0; i < this.temp.size(); ++i) {
            this.addItem(this.temp.get(i), i);
        }
        this.table.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail != 4 || !TablePart.this.table.isFocusControl()) {
                    return;
                }
                e.doit = false;
                TablePart.this.open(TablePart.this.getSelection());
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (TablePart.this.action == null || e.button != 1) {
                    return;
                }
                TablePart.this.open(TablePart.this.getSelection());
            }

            public void mouseDown(MouseEvent e) {
                if (TablePart.this.menu != null) {
                    TablePart.this.menu.setCurrentObject(TablePart.this.getSelection());
                }
            }
        });
        if (this.rememberState) {
            this.addSelectionListener(new Listener(){

                public void handleEvent(Event event) {
                    try {
                        state.put((Object)(TablePart.this.getID() + ".object"), event.data);
                        state.put((Object)(TablePart.this.getID() + ".index"), (Object)TablePart.this.table.getTopIndex());
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to store table state", (Throwable)e);
                    }
                }
            });
        }
        this.table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int listeners = TablePart.this.selectionListeners.size();
                if (listeners == 0 && TablePart.this.menu == null) {
                    return;
                }
                event.data = TablePart.this.getSelection();
                if (TablePart.this.menu != null) {
                    TablePart.this.menu.setCurrentObject(event.data);
                }
                if (listeners == 0) {
                    return;
                }
                if (TablePart.this.checkable && event.detail != 32) {
                    return;
                }
                for (Listener l : TablePart.this.selectionListeners) {
                    try {
                        l.handleEvent(event);
                    }
                    catch (Throwable t) {
                        Logger.error((String)"error while executing listener, skipping", (Throwable)t);
                    }
                }
            }
        });
        if (this.changeable) {
            this.editor = new TableEditor(this.table);
            this.editor.horizontalAlignment = 16384;
            this.editor.grabHorizontal = true;
            this.table.addListener(3, new Listener(){

                public void handleEvent(Event e) {
                    boolean enabled;
                    if (e.button != 1) {
                        return;
                    }
                    TableItem current = null;
                    int row = -1;
                    int cols = TablePart.this.table.getColumnCount();
                    int items = TablePart.this.table.getItemCount();
                    Point pt = new Point(e.x, e.y);
                    block0: for (int pos = TablePart.this.table.getTopIndex(); pos < items; ++pos) {
                        current = TablePart.this.table.getItem(pos);
                        for (int i = 0; i < cols; ++i) {
                            Rectangle rect = current.getBounds(i);
                            if (!rect.contains(pt)) continue;
                            row = i;
                            pos = items;
                            continue block0;
                        }
                    }
                    if (row == -1 || current == null || row > TablePart.this.columns.size()) {
                        return;
                    }
                    final Column col = (Column)TablePart.this.columns.get(row);
                    if (!col.canChange()) {
                        return;
                    }
                    final TableItem item = current;
                    final int index = row;
                    final String oldValue = item.getText(index);
                    final Control editorControl = TablePart.this.getEditorControl(row, item, oldValue);
                    if (editorControl == null) {
                        return;
                    }
                    TablePart.this.editor.setEditor(editorControl, item, index);
                    if (item.getData("color") == null) {
                        item.setData("color", (Object)item.getForeground());
                    }
                    final Color color = (Color)item.getData("color");
                    Button b = GUI.getShell().getDefaultButton();
                    if (b != null && !b.isDisposed() && b.isEnabled()) {
                        enabled = b.getEnabled();
                        b.setEnabled(false);
                    } else {
                        enabled = false;
                    }
                    final Runnable done = new Runnable(){

                        @Override
                        public void run() {
                            Button b;
                            if (editorControl != null && !editorControl.isDisposed()) {
                                editorControl.dispose();
                            }
                            if ((b = GUI.getShell().getDefaultButton()) != null && !b.isDisposed()) {
                                b.setEnabled(enabled);
                            }
                            TablePart.this.select(item.getData());
                        }
                    };
                    final Runnable commit = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                String[] values;
                                String newValue = TablePart.this.getControlValue(editorControl);
                                if (oldValue == null && newValue == null) {
                                    return;
                                }
                                if (oldValue != null && oldValue.equals(newValue)) {
                                    return;
                                }
                                item.setText(index, newValue);
                                for (TableChangeListener l : TablePart.this.changeListeners) {
                                    try {
                                        l.itemChanged(item.getData(), col.getColumnId(), newValue);
                                        if (color == null) continue;
                                        item.setForeground(index, color);
                                    }
                                    catch (ApplicationException ae) {
                                        item.setForeground(index, de.willuhn.jameica.gui.util.Color.ERROR.getSWTColor());
                                        String msg = ae.getMessage();
                                        if (msg == null || msg.length() == 0) {
                                            msg = TablePart.this.i18n.tr("Fehler beim \u00c4ndern des Wertes");
                                            Logger.error((String)"error while changing value", (Throwable)ae);
                                        }
                                        Application.getMessagingFactory().sendMessage(new StatusBarMessage(msg, 1));
                                        break;
                                    }
                                }
                                if (TablePart.this.tableFormatter != null) {
                                    TablePart.this.tableFormatter.format(item);
                                }
                                if ((values = TablePart.this.textTable.get(item.getData())) != null) {
                                    values[index] = newValue;
                                }
                            }
                            finally {
                                done.run();
                            }
                        }
                    };
                    editorControl.addTraverseListener(new TraverseListener(){

                        public void keyTraversed(TraverseEvent e) {
                            if (!editorControl.isFocusControl()) {
                                return;
                            }
                            if (e.detail == 4) {
                                e.doit = false;
                                commit.run();
                            } else if (e.detail == 2) {
                                e.doit = false;
                                done.run();
                            }
                        }
                    });
                    editorControl.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusLost(FocusEvent e) {
                            commit.run();
                        }
                    });
                }
            });
        }
        if (this.menu != null) {
            this.menu.paint((Composite)this.table);
        }
        int cols = this.table.getColumnCount();
        for (int i2 = 0; i2 < cols; ++i2) {
            col = this.table.getColumn(i2);
            if (this.rememberColWidth) {
                int size = 0;
                try {
                    size = settings.getInt("width." + this.getID() + "." + i2, 0);
                }
                catch (Exception e) {
                    Logger.error((String)"unable to restore column width", (Throwable)e);
                }
                if (size <= 0) {
                    col.pack();
                    continue;
                }
                col.setWidth(size);
                continue;
            }
            col.pack();
        }
        if (this.rememberOrder) {
            try {
                String s = settings.getString("order." + this.getID(), null);
                if (s != null && s.length() > 0) {
                    Logger.debug((String)("restoring last table order: " + s));
                    this.orderBy(s);
                }
            }
            catch (Exception e) {
                Logger.error((String)"unable to restore last table order", (Throwable)e);
            }
        }
        this.restoreState();
        this.temp.clear();
        this.featureEvent(Feature.Event.PAINT, null);
    }

    @Override
    String getID() throws Exception {
        if (this.id != null) {
            return this.id;
        }
        StringBuffer sb = new StringBuffer();
        if (this.size() > 0) {
            if (this.table == null || this.table.isDisposed()) {
                sb.append(this.temp.get(0).getClass().getName());
            } else {
                sb.append(this.table.getItem(0).getData().getClass().getName());
            }
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            Column col = (Column)this.columns.get(i);
            sb.append(col.getColumnId());
        }
        String s = sb.toString();
        if (s == null || s.length() == 0) {
            s = "unknown";
        }
        this.id = Checksum.md5((byte[])s.getBytes());
        return this.id;
    }

    @Override
    public void select(Object[] objects) {
        if (objects == null || objects.length == 0 || this.table == null) {
            return;
        }
        if (!this.multi && objects.length > 1) {
            Logger.warn((String)"multi selection disabled but user wants to select more than one element, selecting only the first one");
            this.select(objects[0]);
            return;
        }
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i] == null) continue;
            TableItem[] items = this.table.getItems();
            for (int j = 0; j < items.length; ++j) {
                Object o;
                if (items[j] == null || (o = items[j].getData()) == null) continue;
                try {
                    if (!BeanUtil.equals((Object)objects[i], (Object)o)) continue;
                    this.table.select(j);
                    continue;
                }
                catch (RemoteException e) {
                    Logger.error((String)"error while selecting table item", (Throwable)e);
                }
            }
        }
        this.table.setFocus();
    }

    @Override
    public void setChecked(Object[] objects, boolean checked) {
        if (objects == null || objects.length == 0 || !this.checkable) {
            return;
        }
        if (this.table == null || this.table.isDisposed()) {
            Logger.error((String)"unable to set checked state - no paint(Composite) called or table disposed");
            return;
        }
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i] == null) continue;
            TableItem[] items = this.table.getItems();
            for (int j = 0; j < items.length; ++j) {
                Object o;
                if (items[j] == null || (o = items[j].getData()) == null) continue;
                try {
                    if (!BeanUtil.equals((Object)objects[i], (Object)o)) continue;
                    items[j].setChecked(checked);
                    continue;
                }
                catch (RemoteException e) {
                    Logger.error((String)"error while checking table item", (Throwable)e);
                }
            }
        }
    }

    @Override
    public Object getSelection() {
        if (this.table == null || this.table.isDisposed()) {
            return null;
        }
        TableItem[] items = this.table.getSelection();
        if (items == null || items.length == 0) {
            return null;
        }
        if (items.length == 1) {
            return items[0].getData();
        }
        Class<?> type = null;
        ArrayList<Object> data = new ArrayList<Object>();
        for (int i = 0; i < items.length; ++i) {
            Object elem = items[i].getData();
            if (elem == null) continue;
            if (type == null) {
                type = elem.getClass();
            }
            data.add(elem);
        }
        try {
            Object[] array = (Object[])Array.newInstance(type, data.size());
            return data.toArray(array);
        }
        catch (Exception e) {
            Logger.debug((String)"unable to create type safe array, fallback to generic array");
            return data.toArray();
        }
    }

    @Deprecated
    protected void refreshSummary() {
        this.featureEvent(Feature.Event.REFRESH, null);
    }

    @Deprecated
    protected String getSummary() {
        int size = this.size();
        if (size != 1) {
            return this.i18n.tr("{0} Datens\u00e4tze", Integer.toString(size));
        }
        return this.i18n.tr("1 Datensatz");
    }

    protected void orderBy(String colName) {
        boolean bl = this.direction = !colName.startsWith("!");
        if (!this.direction) {
            colName = colName.substring(1);
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            Column col = (Column)this.columns.get(i);
            if (col == null) {
                return;
            }
            String id = col.getColumnId();
            if (id == null || !id.equals(colName)) continue;
            Logger.debug((String)("table ordered by " + colName));
            this.orderBy(i);
            return;
        }
    }

    public void sort() {
        this.orderBy(this.sortedBy);
    }

    @Override
    public void restoreState() {
        if (!this.rememberState) {
            return;
        }
        try {
            Integer index;
            Object object = state.get((Object)(this.getID() + ".object"));
            if (object != null) {
                if (object instanceof Object[]) {
                    this.select((Object[])object);
                } else {
                    this.select(object);
                }
            }
            if ((index = (Integer)state.get((Object)(this.getID() + ".index"))) != null) {
                this.setTopIndex(index);
            }
        }
        catch (Exception e) {
            Logger.error((String)"unable to restore last table state", (Throwable)e);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.table != null && !this.table.isDisposed()) {
            this.table.setEnabled(this.enabled);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected Collator getCollator() {
        if (this.collator == null) {
            this.collator = Collator.getInstance(Application.getConfig().getLocale());
        }
        return this.collator;
    }

    protected void orderBy(int index) {
        if (this.table == null || this.table.isDisposed()) {
            return;
        }
        List<Item> l = this.sortTable.get(index);
        if (l == null) {
            return;
        }
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            this.table.getColumn(i).setImage(null);
        }
        TableColumn col = this.table.getColumn(index);
        try {
            Collections.sort(l);
            if (!this.direction) {
                Collections.reverse(l);
            }
        }
        catch (IllegalArgumentException e) {
            Logger.error((String)"unable to sort table", (Throwable)e);
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Sortierung nach dieser Spalte nicht m\u00f6glich"), 1));
        }
        col.setImage(this.direction ? this.down : this.up);
        this.sortedBy = index;
        Object selection = this.getSelection();
        this.table.removeAll();
        Item sort = null;
        for (int i = 0; i < l.size(); ++i) {
            sort = l.get(i);
            TableItem item = new TableItem(this.table, 0, i);
            item.setData(sort.data);
            item.setText(this.textTable.get(sort.data));
            if (this.tableFormatter == null) continue;
            this.tableFormatter.format(item);
        }
        if (selection != null) {
            if (selection instanceof Object[]) {
                this.select((Object[])selection);
            } else {
                this.select(selection);
            }
        }
    }

    private String getOrderedBy() {
        try {
            Column c = (Column)this.columns.get(this.sortedBy);
            return c.getColumnId();
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Control getEditorControl(int row, TableItem item, String oldValue) {
        Text newText = new Text((Composite)this.table, 0);
        newText.setText(oldValue);
        newText.selectAll();
        newText.setFocus();
        return newText;
    }

    protected String getControlValue(Control control) {
        if (control instanceof Text) {
            return ((Text)control).getText();
        }
        return "";
    }

    @Override
    protected Feature.Context createFeatureEventContext(Feature.Event e, Object data) {
        Feature.Context ctx = super.createFeatureEventContext(e, data);
        ctx.control = this.table;
        if (this.hasEvent(FeatureSummary.class, e)) {
            ctx.addon.put("summary.text", this.getSummary());
        }
        return ctx;
    }

    private class DeleteListener
    implements de.willuhn.datasource.rmi.Listener {
        private DeleteListener() {
        }

        public void handleEvent(final de.willuhn.datasource.rmi.Event e) throws RemoteException {
            try {
                TablePart.this.removeItem(e.getObject());
            }
            catch (SWTException ex) {
                GUI.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            TablePart.this.removeItem(e.getObject());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        }
    }

    class Item
    extends AbstractTablePart.AbstractTableItem {
        private Item(Object data, Column col) {
            this.data = data;
            if (col == null) {
                return;
            }
            this.column = col;
            this.update();
        }

        private void update() {
            try {
                this.value = BeanUtil.get((Object)this.data, (String)this.column.getColumnId());
                this.sortValue = this.value instanceof Comparable ? (Comparable)this.value : BeanUtil.toString((Object)this.value);
                if (this.sortValue instanceof String) {
                    this.sortValue = TablePart.this.getCollator().getCollationKey(((String)((Object)this.sortValue)).toLowerCase());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

