/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.parts;

import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.Font;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class Placeholder
implements Part {
    private static final I18N i18n = Application.getI18n();
    private String image = null;
    private String title = null;
    private String text = null;

    public Placeholder(Style style) {
        if (style != null) {
            this.image = style.image;
            this.title = style.title;
        }
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public void paint(Composite parent) throws RemoteException {
        Label l;
        if (parent == null || parent.isDisposed()) {
            return;
        }
        Composite comp = new Composite(parent, 0x40040000);
        comp.setBackgroundMode(2);
        comp.setBackground(parent.getBackground());
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gl = new GridLayout();
        gl.marginHeight = 40;
        gl.verticalSpacing = 10;
        comp.setLayout((Layout)gl);
        if (this.image != null && this.image.length() > 0) {
            Image i = SWTUtil.getImage(this.image);
            Label l2 = new Label(comp, 0);
            l2.setImage(i);
            l2.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        }
        if (this.title != null && this.title.length() > 0) {
            l = new Label(comp, 0);
            l.setFont(Font.H1.getSWTFont());
            l.setForeground(Color.COMMENT.getSWTColor());
            l.setText(this.title);
            l.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        }
        if (this.text != null && this.text.length() > 0) {
            l = new Label(comp, 0);
            l.setFont(Font.ITALIC.getSWTFont());
            l.setForeground(Color.COMMENT.getSWTColor());
            l.setText(this.text);
            l.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        }
    }

    public static enum Style {
        EMPTY("placeholder-empty.png", i18n.tr("Keine Daten")),
        LOADING("placeholder-loading.png", i18n.tr("Lade...")),
        WAIT("placeholder-wait.png", i18n.tr("Bitte warten...")),
        DONE("placeholder-done.png", i18n.tr("Fertig")),
        ERROR("placeholder-error.png", i18n.tr("Fehler"));

        private String image = null;
        private String title = null;

        private Style(String image, String title) {
            this.image = image;
            this.title = title;
        }
    }
}

