/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.parts;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.util.Font;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class PanelButton
implements Part {
    private static final int ALPHA_DEFAULT = 190;
    private static final int ALPHA_DISABLED = 50;
    private static final int ALPHA_NONE = 255;
    public static final String BG_DEFAULT = "panelbar-button-default.png";
    public static final String BG_HOVER = "panelbar-button-hover.png";
    private Canvas canvas = null;
    private String icon = null;
    private Action action = null;
    private String tooltip = null;
    private String text = null;
    private int height = 0;
    private int width = 0;
    private int textHeight = -1;
    private boolean enabled = true;

    public PanelButton(String icon, Action action, String tooltip) {
        this.icon = icon;
        this.action = action;
        this.tooltip = tooltip;
    }

    @Override
    public void paint(Composite parent) throws RemoteException {
        Rectangle bounds = SWTUtil.getImage(BG_DEFAULT).getBounds();
        try {
            this.height = ((GridData)parent.getLayoutData()).heightHint;
        }
        catch (Exception e) {
            this.height = bounds.height;
        }
        this.width = bounds.width;
        GridData gd = new GridData();
        gd.widthHint = this.width;
        gd.heightHint = this.height;
        this.canvas = new Canvas(parent, 0);
        this.canvas.setBackground(GUI.getDisplay().getSystemColor(25));
        this.canvas.setLayoutData((Object)gd);
        if (this.tooltip != null) {
            this.canvas.setToolTipText(this.tooltip);
        }
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setAlpha(255);
                PanelButton.this.drawBackground(e.gc, PanelButton.BG_DEFAULT);
                e.gc.setAlpha(PanelButton.this.isEnabled() ? 190 : 50);
                PanelButton.this.drawIcon(e.gc, false);
            }
        });
        this.canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button != 1 || !PanelButton.this.isEnabled()) {
                    return;
                }
                GC gc = new GC((Drawable)PanelButton.this.canvas);
                gc.setAlpha(255);
                PanelButton.this.drawBackground(gc, PanelButton.BG_HOVER);
                PanelButton.this.drawIcon(gc, true);
                gc.dispose();
            }

            public void mouseUp(MouseEvent e) {
                if (e.button != 1 || PanelButton.this.action == null || !PanelButton.this.isEnabled()) {
                    return;
                }
                if (e.x < 0 || e.y < 0) {
                    return;
                }
                Image background = SWTUtil.getImage(PanelButton.BG_DEFAULT);
                Rectangle rect = background.getBounds();
                if (e.x > rect.width || e.y > PanelButton.this.height) {
                    return;
                }
                GC gc = new GC((Drawable)PanelButton.this.canvas);
                gc.setAlpha(255);
                PanelButton.this.drawBackground(gc, PanelButton.BG_DEFAULT);
                PanelButton.this.drawIcon(gc, false);
                gc.dispose();
                PanelButton.this.handleClick();
            }
        });
        this.canvas.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                GC gc = new GC((Drawable)PanelButton.this.canvas);
                gc.setAlpha(255);
                PanelButton.this.drawBackground(gc, PanelButton.BG_DEFAULT);
                gc.setAlpha(PanelButton.this.isEnabled() ? 190 : 50);
                PanelButton.this.drawIcon(gc, false);
                gc.dispose();
            }

            public void mouseEnter(MouseEvent e) {
                if (!PanelButton.this.isEnabled()) {
                    return;
                }
                GC gc = new GC((Drawable)PanelButton.this.canvas);
                gc.setAlpha(255);
                PanelButton.this.drawBackground(gc, PanelButton.BG_DEFAULT);
                gc.setAlpha(PanelButton.this.isEnabled() ? 255 : 50);
                PanelButton.this.drawIcon(gc, false);
                gc.dispose();
            }
        });
    }

    private void drawBackground(GC gc, String imageName) {
        Image image = SWTUtil.getImage(imageName);
        Rectangle size = image.getBounds();
        gc.setBackground(GUI.getDisplay().getSystemColor(25));
        gc.fillRectangle(0, 0, this.width, this.height);
        gc.drawImage(image, 0, 0, size.width, size.height, 0, 0, this.width, this.height);
    }

    private void drawIcon(GC gc, boolean pressed) {
        int size = 16;
        int y = (this.height - size) / 2;
        if (pressed) {
            ++y;
        }
        gc.drawImage(SWTUtil.getImage(this.icon), (this.width - size) / 2, y);
        this.drawText(gc, pressed);
    }

    private void drawText(GC gc, boolean pressed) {
        String s = StringUtils.trimToNull((String)this.text);
        if (s == null) {
            return;
        }
        Point size = gc.textExtent(s);
        if (this.textHeight == -1) {
            this.textHeight = size.y;
        }
        gc.setAlpha(190);
        gc.setTextAntialias(1);
        gc.setForeground(GUI.getDisplay().getSystemColor(24));
        gc.setFont(Font.DEFAULT.getSWTFont());
        int x = this.width - size.x - 1;
        int y = this.height - this.textHeight - (pressed ? 0 : 1);
        gc.drawText(s, x, y, true);
    }

    public void setIcon(String icon) {
        if (icon == null) {
            return;
        }
        this.icon = icon;
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.redraw();
        }
    }

    public void setText(String text) {
        this.text = text;
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.redraw();
        }
    }

    public void setTooltip(String tooltip) {
        if (tooltip == null) {
            return;
        }
        this.tooltip = tooltip;
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.setToolTipText(this.tooltip);
        }
    }

    public void setAction(Action a) {
        this.action = a;
    }

    protected Control getControl() {
        return this.canvas;
    }

    protected void handleClick() {
        try {
            this.action.handleAction(null);
        }
        catch (OperationCanceledException oce) {
            Logger.debug((String)"operation cancelled");
        }
        catch (ApplicationException ae) {
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(ae.getMessage(), 1));
        }
        catch (Exception ex) {
            Logger.error((String)"unable to execute action", (Throwable)ex);
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Fehler: {0}", ex.getMessage()), 1));
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
        if (this.canvas != null) {
            GUI.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (PanelButton.this.canvas != null && !PanelButton.this.canvas.isDisposed()) {
                        PanelButton.this.canvas.redraw();
                    }
                }
            });
        }
    }
}

