/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.parts;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class NotificationPanel
implements Part,
MessageConsumer {
    private static final Map<Integer, Type> TYPEMAP = new HashMap<Integer, Type>();
    private boolean receiveMessages = false;
    private Type type = null;
    private String text = null;
    private Composite comp = null;
    private CLabel label = null;
    private int border = 1;
    private boolean background = true;
    private long lastUpdate = 0L;

    public NotificationPanel() {
    }

    public NotificationPanel(Type type, String text) {
        this();
        this.setText(type, text, false);
    }

    public void setReceiveMessages(boolean b) {
        if (b && !this.receiveMessages) {
            Application.getMessagingFactory().registerMessageConsumer(this);
        }
        if (!b && this.receiveMessages) {
            Application.getMessagingFactory().unRegisterMessageConsumer(this);
        }
        this.receiveMessages = b;
    }

    public void setBackground(boolean background) {
        this.background = background;
    }

    public void setBorder(int border) {
        this.border = border;
    }

    @Override
    public void paint(Composite parent) throws RemoteException {
        if (this.comp != null || this.label != null) {
            return;
        }
        this.comp = new Composite(parent, 0);
        this.comp.setLayoutData((Object)new GridData(768));
        GridLayout gl = new GridLayout();
        gl.marginHeight = this.border;
        gl.marginWidth = this.border;
        gl.horizontalSpacing = 3;
        gl.verticalSpacing = 3;
        this.comp.setLayout((Layout)gl);
        this.label = new CLabel(this.comp, 0);
        this.label.setLayoutData((Object)new GridData(1808));
    }

    public void setText(Type t, String s) {
        this.setText(t, s, true);
    }

    private void setText(Type t, String s, final boolean autoHide) {
        this.type = t != null ? t : Type.INFO;
        String string = this.text = s != null ? s : "";
        if (this.comp == null || this.label == null) {
            return;
        }
        final long currentUpdate = System.currentTimeMillis();
        try {
            GUI.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (NotificationPanel.this.label.isDisposed()) {
                        return;
                    }
                    NotificationPanel.this.label.setImage(NotificationPanel.this.type.icon != null ? SWTUtil.getImage(NotificationPanel.this.type.icon) : null);
                    NotificationPanel.this.label.setForeground(NotificationPanel.this.type.fg.getSWTColor());
                    NotificationPanel.this.label.setText(NotificationPanel.this.text.replaceAll("&", "&&"));
                    NotificationPanel.this.label.setToolTipText(NotificationPanel.this.label.getText());
                    if (NotificationPanel.this.background) {
                        NotificationPanel.this.label.setBackground(NotificationPanel.this.type.bg.getSWTColor());
                        NotificationPanel.this.comp.setBackground(NotificationPanel.this.type.fg.getSWTColor());
                    }
                    NotificationPanel.this.lastUpdate = currentUpdate;
                    if (autoHide) {
                        GUI.getDisplay().timerExec(7000, new Runnable(){

                            @Override
                            public void run() {
                                if (currentUpdate == NotificationPanel.this.lastUpdate) {
                                    NotificationPanel.this.reset();
                                }
                            }
                        });
                    }
                }
            });
        }
        catch (OperationCanceledException oce) {
            Logger.debug((String)oce.getMessage());
        }
    }

    public void reset() {
        this.setText(Type.INVISIBLE, null, false);
    }

    @Override
    public Class[] getExpectedMessageTypes() {
        return new Class[]{StatusBarMessage.class};
    }

    @Override
    public void handleMessage(Message message) throws Exception {
        if (message == null) {
            return;
        }
        StatusBarMessage m = (StatusBarMessage)message;
        Type type = TYPEMAP.get(m.getType());
        this.setText(type, m.getText());
    }

    @Override
    public boolean autoRegister() {
        return false;
    }

    static {
        if (!Application.inServerMode()) {
            TYPEMAP.put(1, Type.ERROR);
            TYPEMAP.put(0, Type.SUCCESS);
            TYPEMAP.put(2, Type.INFO);
        }
    }

    public static enum Type {
        SUCCESS("ok.png", new Color(null, new RGB(216, 244, 178)), new Color(null, new RGB(56, 75, 30))),
        ERROR("dialog-error.png", new Color(null, new RGB(255, 216, 185)), new Color(null, new RGB(111, 41, 35))),
        INFO("gtk-info.png", new Color(null, new RGB(178, 216, 244)), new Color(null, new RGB(30, 56, 75))),
        INVISIBLE(null, Color.BACKGROUND, Color.BACKGROUND);

        private String icon = null;
        private Color fg = null;
        private Color bg = null;

        private Type(String icon, Color bg, Color fg) {
            this.icon = icon;
            this.bg = bg;
            this.fg = fg;
        }
    }
}

