/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.parts;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import org.eclipse.swt.graphics.Image;

public class ContextMenuItem {
    private boolean separator = false;
    private String text = null;
    private Action action = null;
    private Image image = null;
    private String shortcut = null;
    public static final ContextMenuItem SEPARATOR = new ContextMenuItem();

    public ContextMenuItem() {
        this(null, null);
    }

    public ContextMenuItem(String text, Action a) {
        this(text, a, null);
    }

    public ContextMenuItem(String text, Action a, String icon) {
        this.text = text;
        this.action = a;
        if (icon != null) {
            try {
                this.setImage(SWTUtil.getImage(icon));
            }
            catch (Exception e) {
                Logger.warn((String)("icon " + icon + " not found"));
            }
        }
    }

    public void setSeparator(boolean separator) {
        this.separator = separator;
    }

    public boolean isSeparator() {
        return this.separator;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public Action getAction() {
        return this.action;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public void setAction(Action a) {
        this.action = a;
    }

    public String getShortcut() {
        return this.shortcut;
    }

    public void setShortcut(String shortcut) {
        this.shortcut = Application.getPlatform().mapSWTShortcut(shortcut);
    }

    public boolean isEnabledFor(Object o) {
        return true;
    }

    static {
        SEPARATOR.setSeparator(true);
    }
}

