/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.parts;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.jameica.gui.formatter.Formatter;
import de.willuhn.jameica.gui.parts.AbstractTablePart;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import java.io.Serializable;
import org.eclipse.swt.widgets.Item;

public class Column
implements Serializable {
    public static final int ALIGN_LEFT = 16384;
    public static final int ALIGN_CENTER = 0x1000000;
    public static final int ALIGN_RIGHT = 131072;
    public static final int ALIGN_AUTO = -1;
    public static final int SORT_BY_VALUE = 1;
    public static final int SORT_BY_DISPLAY = 2;
    public static final int SORT_DEFAULT = 1;
    private String columnId = null;
    private String name = null;
    private Formatter formatter = null;
    private boolean canChange = false;
    private int align = -1;
    private int sort = 1;
    private transient Item column = null;

    public Column(String id, String name) {
        this(id, name, null);
    }

    public Column(String id, String name, Formatter f) {
        this(id, name, f, false);
    }

    public Column(String id, String name, Formatter f, boolean changeable) {
        this(id, name, f, changeable, -1);
    }

    public Column(String id, String name, Formatter f, boolean changeable, int align) {
        this(id, name, f, changeable, align, 1);
    }

    public Column(String id, String name, Formatter f, boolean changeable, int align, int sort) {
        this.columnId = id;
        this.name = name;
        this.formatter = f;
        this.canChange = changeable;
        this.align = align;
        this.sort = sort;
    }

    public int getAlign() {
        return this.align;
    }

    public boolean canChange() {
        return this.canChange;
    }

    public String getColumnId() {
        return this.columnId;
    }

    public Formatter getFormatter() {
        return this.formatter;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (this.column != null && !this.column.isDisposed()) {
            this.column.setText(name != null ? name : "");
        }
    }

    public int getSortMode() {
        return this.sort;
    }

    public String getFormattedValue(Object value, Object context) {
        if (value == null) {
            return "";
        }
        String display = null;
        try {
            display = this.formatter != null ? this.formatter.format(value) : BeanUtil.toString((Object)value);
        }
        catch (Exception e) {
            Logger.error((String)("unable to format value " + value + " for bean " + context), (Throwable)e);
        }
        return display != null ? display : "";
    }

    void setColumn(Item i) {
        this.column = i;
    }

    public int compare(AbstractTablePart.AbstractTableItem i1, AbstractTablePart.AbstractTableItem i2) {
        try {
            if (i1.sortValue == i2.sortValue) {
                return 0;
            }
            if (i1.sortValue == null) {
                return -1;
            }
            if (i2.sortValue == null) {
                return 1;
            }
            if (this.getSortMode() == 2) {
                return i1.column.getFormattedValue(i1.value, i1.data).compareTo(i2.column.getFormattedValue(i2.value, i2.data));
            }
            return i1.sortValue.compareTo(i2.sortValue);
        }
        catch (Exception e) {
            Logger.write((Level)Level.INFO, (String)"unable to compare values", (Throwable)e);
            return 0;
        }
    }
}

