/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.parts;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.pseudo.PseudoIterator;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.formatter.Formatter;
import de.willuhn.jameica.gui.parts.Column;
import de.willuhn.jameica.gui.parts.ContextMenu;
import de.willuhn.jameica.gui.parts.table.Feature;
import de.willuhn.jameica.gui.parts.table.FeatureClipboard;
import de.willuhn.jameica.gui.parts.table.FeatureSelectAll;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Listener;

public abstract class AbstractTablePart
implements Part {
    protected ContextMenu menu = null;
    protected boolean changeable = false;
    protected boolean rememberColWidth = false;
    protected boolean rememberOrder = false;
    protected boolean rememberState = false;
    protected List<Column> columns = new LinkedList<Column>();
    protected static final Settings settings = new Settings(AbstractTablePart.class);
    protected boolean multi = false;
    protected boolean checkable = false;
    protected List<Listener> selectionListeners = new ArrayList<Listener>();
    protected Action action = null;
    private Map<Class, Feature> features = new HashMap<Class, Feature>();

    public AbstractTablePart(Action action) {
        this.action = action;
        this.addFeature(new FeatureClipboard());
        this.addFeature(new FeatureSelectAll());
    }

    public void addFeature(Feature feature) {
        if (feature == null) {
            Logger.warn((String)"no feature given");
            return;
        }
        this.features.put(feature.getClass(), feature);
    }

    public void addFeature(String featureName) {
        if ((featureName = StringUtils.trimToNull((String)featureName)) == null) {
            Logger.warn((String)"no feature name given");
            return;
        }
        try {
            Class c = Application.getClassLoader().load(featureName);
            BeanService bs = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            this.addFeature((Feature)bs.get(c));
        }
        catch (Exception e) {
            Logger.warn((String)("feature not found: " + featureName));
            return;
        }
    }

    public void removeFeature(Class<? extends Feature> type) {
        if (type == null) {
            return;
        }
        this.features.remove(type);
    }

    public <T> T getFeature(Class<? extends Feature> type) {
        if (type == null) {
            return null;
        }
        return (T)this.features.get(type);
    }

    public boolean hasEvent(Class<? extends Feature> type, Feature.Event e) {
        Feature f = (Feature)this.getFeature(type);
        return f != null && f.onEvent(e);
    }

    public void featureEvent(Feature.Event e, Object data) {
        if (this.features.size() == 0) {
            return;
        }
        Feature.Context ctx = this.createFeatureEventContext(e, data);
        for (Feature f : this.features.values()) {
            if (!f.onEvent(e)) continue;
            try {
                f.handleEvent(e, ctx);
            }
            catch (Exception ex) {
                Logger.error((String)("error while handling event " + e), (Throwable)ex);
            }
        }
    }

    public abstract int size();

    protected Feature.Context createFeatureEventContext(Feature.Event e, Object data) {
        Feature.Context ctx = new Feature.Context();
        ctx.part = this;
        ctx.menu = this.menu;
        ctx.data = data;
        return ctx;
    }

    public void addColumn(String title, String field) {
        this.addColumn(title, field, null);
    }

    public void addColumn(String title, String field, Formatter f) {
        this.addColumn(title, field, f, false);
    }

    public void addColumn(String title, String field, Formatter f, boolean changeable) {
        this.addColumn(title, field, f, changeable, -1);
    }

    public void addColumn(String title, String field, Formatter f, boolean changeable, int align) {
        this.addColumn(new Column(field, title, f, changeable, align));
    }

    public void addColumn(Column col) {
        this.columns.add(col);
        this.changeable |= col.canChange();
    }

    int[] getColumnOrder() {
        try {
            String order = settings.getString("column.order." + this.getID(), null);
            if (order == null || order.length() == 0 || order.indexOf(",") == -1) {
                return null;
            }
            String[] s = order.split(",");
            if (s.length != this.columns.size()) {
                Logger.warn((String)("column count missmatch. column order: " + order + ", columns: " + this.columns.size()));
                return null;
            }
            int[] cols = new int[s.length];
            for (int i = 0; i < s.length; ++i) {
                cols[i] = Integer.parseInt(s[i]);
            }
            return cols;
        }
        catch (Exception e) {
            Logger.warn((String)("unable to determine column order: " + e.toString()));
            return null;
        }
    }

    void setColumnOrder(int[] cols) {
        try {
            Object s = "";
            if (cols != null && cols.length > 0) {
                for (int i = 0; i < cols.length; ++i) {
                    s = (String)s + Integer.toString(cols[i]);
                    if (i + 1 >= cols.length) continue;
                    s = (String)s + ",";
                }
            }
            settings.setAttribute("column.order." + this.getID(), (String)(((String)s).length() == 0 ? null : s));
        }
        catch (Exception e) {
            Logger.error((String)"unable to save column order", (Throwable)e);
        }
    }

    public void setContextMenu(ContextMenu menu) {
        this.menu = menu;
    }

    abstract String getID() throws Exception;

    public abstract List getItems() throws RemoteException;

    public abstract Object getSelection();

    public abstract void select(Object[] var1);

    public void select(Object o) {
        this.select(new Object[]{o});
    }

    void open(Object o) {
        if (this.action == null || o == null) {
            return;
        }
        try {
            this.action.handleAction(o);
        }
        catch (ApplicationException ae) {
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(ae.getMessage(), 1));
        }
    }

    public void setRememberColWidths(boolean remember) {
        this.rememberColWidth = remember;
    }

    public void setRememberOrder(boolean remember) {
        this.rememberOrder = remember;
    }

    public void setRememberState(boolean remember) {
        this.rememberState = remember;
    }

    public void restoreState() {
    }

    public void setMulti(boolean multi) {
        this.multi = multi;
    }

    public boolean isMulti() {
        return this.multi;
    }

    public void setCheckable(boolean checkable) {
        this.checkable = checkable;
    }

    public void setChecked(Object[] objects, boolean checked) {
        Logger.warn((String)("setChecked not implemented in " + this.getClass().getName()));
    }

    public void setChecked(Object o, boolean checked) {
        this.setChecked(new Object[]{o}, checked);
    }

    public void addSelectionListener(Listener l) {
        if (l != null) {
            this.selectionListeners.add(l);
        }
    }

    public abstract void removeAll();

    protected static List asList(GenericIterator iterator) {
        if (iterator == null) {
            return null;
        }
        try {
            return PseudoIterator.asList((GenericIterator)iterator);
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to init list", (Throwable)re);
            return new ArrayList();
        }
    }

    public abstract class AbstractTableItem
    implements Comparable {
        public Object data;
        public Object value;
        public Column column;
        public Comparable sortValue;

        public int compareTo(Object o) {
            if (!(o instanceof AbstractTableItem)) {
                return -1;
            }
            AbstractTableItem other = (AbstractTableItem)o;
            return this.column.compare(this, other);
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof AbstractTableItem)) {
                return false;
            }
            try {
                return BeanUtil.equals((Object)this.data, (Object)((AbstractTableItem)obj).data);
            }
            catch (RemoteException e) {
                Logger.error((String)"error while comparing items", (Throwable)e);
                return false;
            }
        }
    }
}

