/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.views;

import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.boxes.Box;
import de.willuhn.jameica.gui.boxes.BoxRegistry;
import de.willuhn.jameica.gui.extension.Extendable;
import de.willuhn.jameica.gui.internal.dialogs.ChooseBoxesDialog;
import de.willuhn.jameica.gui.parts.ExpandPart;
import de.willuhn.jameica.gui.parts.PanelButton;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Customizing;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.util.List;
import org.eclipse.swt.layout.GridLayout;

public class Start
extends AbstractView
implements Extendable {
    @Override
    public void bind() throws Exception {
        GUI.getView().setTitle(Application.getI18n().tr("Willkommen"));
        if (!Customizing.SETTINGS.getBoolean("application.start.hidecustomize", false)) {
            PanelButton button = new PanelButton("document-properties.png", new Action(){

                @Override
                public void handleAction(Object context) throws ApplicationException {
                    ChooseBoxesDialog d = new ChooseBoxesDialog(1);
                    try {
                        d.open();
                    }
                    catch (OperationCanceledException oce) {
                        return;
                    }
                    catch (Exception e) {
                        Logger.error((String)"error while loading box config dialog", (Throwable)e);
                    }
                }
            }, Application.getI18n().tr("Startseite anpassen"));
            GUI.getView().addPanelButton(button);
        }
        GridLayout layout = (GridLayout)this.getParent().getLayout();
        layout.horizontalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.paint(false);
    }

    private void paint(boolean dispose) throws Exception {
        if (dispose) {
            SWTUtil.disposeChildren(this.getParent());
        }
        ExpandPart expand = new ExpandPart();
        List<Box> boxes = BoxRegistry.getBoxes();
        for (Box b : boxes) {
            try {
                expand.add(b);
            }
            catch (Exception e) {
                Logger.error((String)("unable to add box " + b.getName() + ", skipping"), (Throwable)e);
            }
        }
        expand.paint(this.getParent());
        if (dispose) {
            this.getParent().layout(true);
        }
    }

    @Override
    public String getExtendableID() {
        return this.getClass().getName();
    }

    @Override
    public boolean canBookmark() {
        return false;
    }

    @Override
    public boolean canAttach() {
        return false;
    }

    @Override
    public void reload() throws ApplicationException {
        GUI.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Start.this.paint(true);
                    Start.super.reload();
                }
                catch (Exception e) {
                    Logger.error((String)"unable to reload view", (Throwable)e);
                }
            }
        });
    }
}

