/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.parts;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.GenericObjectNode;
import de.willuhn.datasource.pseudo.PseudoIterator;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.parts.TreePart;
import de.willuhn.jameica.gui.parts.table.Feature;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.search.Result;
import de.willuhn.jameica.search.SearchResult;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Customizing;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.widgets.Composite;

public class SearchResultPart
extends TreePart {
    public SearchResultPart(List<SearchResult> searchResult) throws RemoteException, ApplicationException {
        super((List)null, new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                if (context == null || !(context instanceof ResultObject)) {
                    return;
                }
                try {
                    ((ResultObject)context).r.execute();
                }
                catch (RemoteException re) {
                    Logger.error((String)"unable to open result", (Throwable)re);
                    Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Fehler beim \u00d6ffnen des Suchergebnisses"), 1));
                }
            }
        });
        Object first;
        List<NotFound> l = this.createList(searchResult);
        Object v0 = first = l != null && l.size() > 0 ? l.get(0) : null;
        if (first != null) {
            this.addFeature(new Feature(){

                @Override
                public boolean onEvent(Feature.Event e) {
                    return e == Feature.Event.PAINT;
                }

                @Override
                public void handleEvent(Feature.Event e, Feature.Context ctx) {
                    SearchResultPart.this.select(first);
                    ctx.control.forceFocus();
                }
            });
        }
        if (l.size() == 0) {
            l = Arrays.asList(new NotFound());
        }
        this.setList(l);
        this.addColumn(Application.getI18n().tr("Bezeichnung"), "name");
        this.setExpanded(true);
        this.setRememberColWidths(true);
    }

    @Override
    public void paint(Composite parent) throws RemoteException {
        super.paint(parent);
    }

    private List createList(List<SearchResult> searchResult) throws RemoteException, ApplicationException {
        HashMap<de.willuhn.jameica.plugin.Plugin, Plugin> plugins = new HashMap<de.willuhn.jameica.plugin.Plugin, Plugin>();
        Plugin system = new Plugin(Application.getManifest().getName());
        for (int i = 0; i < searchResult.size(); ++i) {
            SearchResult result = searchResult.get(i);
            de.willuhn.jameica.plugin.Plugin ap = Application.getPluginLoader().findByClass(result.getSearchProvider().getClass());
            Plugin p = null;
            if (ap == null) {
                p = system;
            } else {
                p = (Plugin)plugins.get(ap);
                if (p == null) {
                    p = new Plugin(ap.getManifest().getName());
                    plugins.put(ap, p);
                }
            }
            p.add(result);
        }
        Iterator result = plugins.values().iterator();
        ArrayList<Plugin> al = new ArrayList<Plugin>();
        if (system.providers.size() > 0) {
            al.add(system);
        }
        while (result.hasNext()) {
            Plugin p = (Plugin)result.next();
            if (p.providers.size() <= 0) continue;
            al.add(p);
        }
        if (Customizing.SETTINGS.getBoolean("application.search.hideplugins", false)) {
            ArrayList<Provider> providers = new ArrayList<Provider>();
            for (Plugin p : al) {
                providers.addAll(p.providers);
            }
            return providers;
        }
        return al;
    }

    private static class NotFound
    implements GenericObject {
        private NotFound() {
        }

        public boolean equals(GenericObject arg0) throws RemoteException {
            return false;
        }

        public Object getAttribute(String arg0) throws RemoteException {
            return Application.getI18n().tr("Keine Treffer gefunden");
        }

        public String[] getAttributeNames() throws RemoteException {
            return new String[]{"name"};
        }

        public String getID() throws RemoteException {
            return "none";
        }

        public String getPrimaryAttribute() throws RemoteException {
            return "name";
        }
    }

    private static class Plugin
    implements GenericObjectNode {
        private String name = null;
        private ArrayList<Provider> providers = new ArrayList();

        private Plugin(String name) {
            this.name = name;
        }

        private void add(SearchResult result) throws RemoteException {
            Provider p = new Provider(this, result);
            if (p.getChildren().size() > 0) {
                this.providers.add(p);
            }
        }

        public GenericIterator getChildren() throws RemoteException {
            return PseudoIterator.fromArray((GenericObject[])((GenericObject[])this.providers.toArray(new Provider[this.providers.size()])));
        }

        public GenericObjectNode getParent() throws RemoteException {
            return null;
        }

        public GenericIterator getPath() throws RemoteException {
            return null;
        }

        public GenericIterator getPossibleParents() throws RemoteException {
            return null;
        }

        public boolean hasChild(GenericObjectNode object) throws RemoteException {
            if (object == null || !(object instanceof Provider)) {
                return false;
            }
            return this.providers.contains(object);
        }

        public boolean equals(GenericObject other) throws RemoteException {
            if (other == null || !(other instanceof Plugin)) {
                return false;
            }
            return this.getID().equals(other.getID());
        }

        public Object getAttribute(String arg0) throws RemoteException {
            return this.name;
        }

        public String[] getAttributeNames() throws RemoteException {
            return new String[]{"name"};
        }

        public String getID() throws RemoteException {
            return this.name;
        }

        public String getPrimaryAttribute() throws RemoteException {
            return "name";
        }
    }

    private static class ResultObject
    implements GenericObjectNode {
        private Provider provider = null;
        private Result r = null;

        private ResultObject(Provider provider, Result r) {
            this.provider = provider;
            this.r = r;
        }

        public GenericIterator getChildren() throws RemoteException {
            return null;
        }

        public GenericObjectNode getParent() throws RemoteException {
            return this.provider;
        }

        public GenericIterator getPath() throws RemoteException {
            return null;
        }

        public GenericIterator getPossibleParents() throws RemoteException {
            return null;
        }

        public boolean hasChild(GenericObjectNode other) throws RemoteException {
            return false;
        }

        public boolean equals(GenericObject other) throws RemoteException {
            if (other == null || !(other instanceof ResultObject)) {
                return false;
            }
            return this.getID().equals(other.getID());
        }

        public Object getAttribute(String arg0) throws RemoteException {
            return this.r.getName();
        }

        public String[] getAttributeNames() throws RemoteException {
            return new String[]{"name"};
        }

        public String getID() throws RemoteException {
            return "" + this.r.hashCode();
        }

        public String getPrimaryAttribute() throws RemoteException {
            return "name";
        }
    }

    private static class Provider
    implements GenericObjectNode {
        private Plugin plugin = null;
        private SearchResult result = null;
        private GenericIterator children = null;

        private Provider(Plugin plugin, SearchResult result) {
            this.plugin = plugin;
            this.result = result;
        }

        public GenericIterator getChildren() throws RemoteException {
            if (this.children == null) {
                ArrayList<ResultObject> l = new ArrayList<ResultObject>();
                try {
                    List result = this.result.getResult();
                    if (result != null) {
                        for (int i = 0; i < result.size(); ++i) {
                            l.add(new ResultObject(this, (Result)result.get(i)));
                        }
                    }
                }
                catch (ApplicationException ae) {
                    Application.getMessagingFactory().sendMessage(new StatusBarMessage(ae.getMessage(), 1));
                }
                this.children = PseudoIterator.fromArray((GenericObject[])((GenericObject[])l.toArray(new ResultObject[l.size()])));
            }
            return this.children;
        }

        public GenericObjectNode getParent() throws RemoteException {
            return this.plugin;
        }

        public GenericIterator getPath() throws RemoteException {
            return null;
        }

        public GenericIterator getPossibleParents() throws RemoteException {
            return null;
        }

        public boolean hasChild(GenericObjectNode other) throws RemoteException {
            if (other == null || !(other instanceof ResultObject)) {
                return false;
            }
            return this.getChildren().contains((GenericObject)other) != null;
        }

        public boolean equals(GenericObject other) throws RemoteException {
            if (other == null || !(other instanceof Provider)) {
                return false;
            }
            return this.getID().equals(other.getID());
        }

        public Object getAttribute(String arg0) throws RemoteException {
            return this.result.getSearchProvider().getName();
        }

        public String[] getAttributeNames() throws RemoteException {
            return new String[]{"name"};
        }

        public String getID() throws RemoteException {
            return this.plugin.name + this.result.getSearchProvider().getName();
        }

        public String getPrimaryAttribute() throws RemoteException {
            return "name";
        }
    }
}

