/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.parts;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.formatter.TableFormatter;
import de.willuhn.jameica.gui.internal.menus.RepositoryListMenu;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.parts.table.FeatureSummary;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.MessagingFactory;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.services.RepositoryService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableItem;

public class RepositoryList
extends TablePart {
    private static final I18N i18n = Application.getI18n();
    private static final RepositoryService repoService = (RepositoryService)Application.getBootLoader().getBootable(RepositoryService.class);
    private MessageConsumer add = new AddMessageConsumer();
    private MessageConsumer remove = new RemoveMessageConsumer();
    private MessageConsumer status = new StatusMessageConsumer();

    public RepositoryList() throws Exception {
        super(RepositoryList.init(), null);
        this.addColumn(i18n.tr("URL"), "url");
        this.setContextMenu(new RepositoryListMenu());
        this.setMulti(false);
        this.setRememberColWidths(true);
        this.setRememberOrder(true);
        this.removeFeature(FeatureSummary.class);
        this.setFormatter(new TableFormatter(){

            @Override
            public void format(TableItem item) {
                try {
                    RepositoryEntry u = (RepositoryEntry)item.getData();
                    if (u == null) {
                        return;
                    }
                    item.setForeground(u.enabled ? Color.FOREGROUND.getSWTColor() : Color.COMMENT.getSWTColor());
                }
                catch (Exception e) {
                    Logger.error((String)"unable to format url", (Throwable)e);
                }
            }
        });
    }

    @Override
    public synchronized void paint(Composite parent) throws RemoteException {
        final MessagingFactory mf = Application.getMessagingFactory();
        mf.getMessagingQueue("jameica.update.repository.add").registerMessageConsumer(this.add);
        mf.getMessagingQueue("jameica.update.repository.remove").registerMessageConsumer(this.remove);
        mf.getMessagingQueue("jameica.update.repository.enabled").registerMessageConsumer(this.status);
        mf.getMessagingQueue("jameica.update.repository.disabled").registerMessageConsumer(this.status);
        super.paint(parent);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                mf.getMessagingQueue("jameica.update.repository.add").unRegisterMessageConsumer(RepositoryList.this.add);
                mf.getMessagingQueue("jameica.update.repository.remove").unRegisterMessageConsumer(RepositoryList.this.remove);
                mf.getMessagingQueue("jameica.update.repository.enabled").unRegisterMessageConsumer(RepositoryList.this.status);
                mf.getMessagingQueue("jameica.update.repository.disabled").unRegisterMessageConsumer(RepositoryList.this.status);
            }
        });
    }

    private static List init() throws Exception {
        ArrayList<RepositoryEntry> urls = new ArrayList<RepositoryEntry>();
        List<URL> l = repoService.getRepositories(true);
        for (URL u : l) {
            urls.add(new RepositoryEntry(u));
        }
        return urls;
    }

    private class AddMessageConsumer
    implements MessageConsumer {
        private AddMessageConsumer() {
        }

        @Override
        public boolean autoRegister() {
            return false;
        }

        @Override
        public Class[] getExpectedMessageTypes() {
            return new Class[]{QueryMessage.class};
        }

        @Override
        public void handleMessage(final Message message) throws Exception {
            GUI.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (message == null) {
                        return;
                    }
                    try {
                        URL url = (URL)((QueryMessage)message).getData();
                        if (url == null) {
                            return;
                        }
                        RepositoryList.this.addItem(new RepositoryEntry(url));
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to add url", (Throwable)e);
                        Application.getMessagingFactory().sendMessage(new StatusBarMessage(i18n.tr("Fehler beim Hinzuf\u00fcgen der URL"), 1));
                    }
                }
            });
        }
    }

    private class RemoveMessageConsumer
    implements MessageConsumer {
        private RemoveMessageConsumer() {
        }

        @Override
        public boolean autoRegister() {
            return false;
        }

        @Override
        public Class[] getExpectedMessageTypes() {
            return new Class[]{QueryMessage.class};
        }

        @Override
        public void handleMessage(final Message message) throws Exception {
            GUI.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (message == null) {
                        return;
                    }
                    try {
                        URL url = (URL)((QueryMessage)message).getData();
                        if (url == null) {
                            return;
                        }
                        List items = RepositoryList.this.getItems();
                        for (RepositoryEntry u : items) {
                            if (!u.url.toString().equals(url.toString())) continue;
                            RepositoryList.this.removeItem(u);
                        }
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to add url", (Throwable)e);
                        Application.getMessagingFactory().sendMessage(new StatusBarMessage(i18n.tr("Fehler beim Hinzuf\u00fcgen der URL"), 1));
                    }
                }
            });
        }
    }

    private class StatusMessageConsumer
    implements MessageConsumer {
        private StatusMessageConsumer() {
        }

        @Override
        public boolean autoRegister() {
            return false;
        }

        @Override
        public Class[] getExpectedMessageTypes() {
            return new Class[]{QueryMessage.class};
        }

        @Override
        public void handleMessage(final Message message) throws Exception {
            GUI.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (message == null) {
                        return;
                    }
                    try {
                        URL url = (URL)((QueryMessage)message).getData();
                        if (url == null) {
                            return;
                        }
                        List items = RepositoryList.this.getItems();
                        for (RepositoryEntry u : items) {
                            if (!u.url.toString().equals(url.toString())) continue;
                            u.enabled = repoService.isEnabled(u.url);
                            RepositoryList.this.updateItem(u, u);
                        }
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to updating url status", (Throwable)e);
                        Application.getMessagingFactory().sendMessage(new StatusBarMessage(i18n.tr("Fehler beim Aktualisieren der der URL: {0}", e.getMessage()), 1));
                    }
                }
            });
        }
    }

    public static class RepositoryEntry {
        private URL url = null;
        private boolean enabled = true;

        private RepositoryEntry(URL url) {
            this.url = url;
            this.enabled = repoService.isEnabled(url);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getUrl() {
            return this.url.toString();
        }

        public String toString() {
            return this.url.toString();
        }
    }
}

