/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.parts;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.input.QueryInput;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.internal.action.PluginInstall;
import de.willuhn.jameica.gui.internal.action.RepositoryEdit;
import de.willuhn.jameica.gui.internal.action.UpdateEdit;
import de.willuhn.jameica.gui.internal.parts.PluginDetailPart;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.Placeholder;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.ColumnLayout;
import de.willuhn.jameica.gui.util.Font;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.gui.util.ScrolledContainer;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.MessagingFactory;
import de.willuhn.jameica.messaging.PluginCacheMessageConsumer;
import de.willuhn.jameica.messaging.PluginMessage;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.plugin.Manifest;
import de.willuhn.jameica.services.RepositoryService;
import de.willuhn.jameica.services.UpdateService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.update.PluginData;
import de.willuhn.jameica.update.PluginGroup;
import de.willuhn.jameica.update.RepositorySearchResult;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.Session;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class PluginListPart
implements Part {
    private static final I18N i18n = Application.getI18n();
    private static final Session availableCache = new Session(600000L);
    private static final Session updateCache = new Session(600000L);
    private MessageConsumer pluginNotify = new MyInstalledMessageConsumer();
    private MessageConsumer repoNotify = new MyRepoMessageConsumer();
    private SelectInput repositories = null;
    private QueryInput query = null;
    private PluginDetailPart.Type focus = null;
    private Map<String, PluginDetailPart> installedParts = new HashMap<String, PluginDetailPart>();
    private ScrolledContainer installedList = null;
    private Map<String, PluginDetailPart> availableParts = new HashMap<String, PluginDetailPart>();
    private ScrolledContainer availableList = null;
    private Map<String, PluginDetailPart> updateParts = new HashMap<String, PluginDetailPart>();
    private ScrolledContainer updateList = null;

    public PluginListPart(PluginDetailPart.Type type) {
        this.focus = type;
    }

    @Override
    public void paint(Composite comp) throws RemoteException {
        SimpleContainer container = new SimpleContainer(comp);
        container.addText(i18n.tr("Nur Plugins im Benutzer-Ordner (oder im System-Ordner, wenn er beschreibbar ist) k\u00f6nnen aktualisiert oder deinstalliert werden.\nBitte starten Sie Jameica nach der Installation bzw. Deinstallation eines Plugins neu."), true, Color.COMMENT);
        container.addText("", true);
        CTabFolder folder = new CTabFolder(comp, 0x800080);
        folder.setLayoutData((Object)new GridData(1808));
        folder.setSimple(true);
        folder.setUnselectedImageVisible(false);
        folder.setUnselectedCloseVisible(false);
        folder.setMinimizeVisible(false);
        folder.setTabHeight(26);
        folder.setMaximizeVisible(false);
        CTabItem item = new CTabItem(folder, 0);
        item.setShowClose(false);
        item.setFont(Font.BOLD.getSWTFont());
        item.setText(this.toTabLabel("Installierte Plugins"));
        if (this.focus != null && this.focus == PluginDetailPart.Type.INSTALLED) {
            folder.setSelection(item);
        }
        SimpleContainer container2 = new SimpleContainer((Composite)folder, true, 1);
        this.installedList = new ScrolledContainer(container2.getComposite(), 1);
        item.setControl((Control)container2.getComposite());
        this.loadInstalled();
        final CTabItem itemAvailable = new CTabItem(folder, 0);
        itemAvailable.setShowClose(false);
        itemAvailable.setFont(Font.BOLD.getSWTFont());
        itemAvailable.setText(this.toTabLabel("Verf\u00fcgbare Plugins"));
        if (this.focus != null && this.focus == PluginDetailPart.Type.AVAILABLE) {
            folder.setSelection(itemAvailable);
        }
        Composite c = new Composite((Composite)folder, 0);
        c.setLayout((Layout)SWTUtil.createGrid(1, true));
        c.setLayoutData((Object)new GridData(1808));
        ColumnLayout cols = new ColumnLayout(c, 2);
        SimpleContainer left = new SimpleContainer(cols.getComposite());
        left.addInput(this.getRepositories());
        SimpleContainer right = new SimpleContainer(cols.getComposite());
        right.addInput(this.getQuery());
        SimpleContainer container3 = new SimpleContainer(c, true, 1);
        this.availableList = new ScrolledContainer(container3.getComposite(), 1);
        itemAvailable.setControl((Control)c);
        final CTabItem itemUpdates = new CTabItem(folder, 0);
        itemUpdates.setShowClose(false);
        itemUpdates.setFont(Font.BOLD.getSWTFont());
        itemUpdates.setText(this.toTabLabel("Updates"));
        if (this.focus != null && this.focus == PluginDetailPart.Type.UPDATE) {
            folder.setSelection(itemUpdates);
        }
        container3 = new SimpleContainer((Composite)folder, true, 1);
        this.updateList = new ScrolledContainer(container3.getComposite(), 1);
        itemUpdates.setControl((Control)container3.getComposite());
        final AtomicBoolean loadedAvailable = new AtomicBoolean(false);
        final AtomicBoolean loadedUpdates = new AtomicBoolean(false);
        folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (e.item == itemAvailable && !loadedAvailable.getAndSet(true)) {
                        PluginListPart.this.loadAvailable();
                    }
                    if (e.item == itemUpdates && !loadedUpdates.getAndSet(true)) {
                        PluginListPart.this.loadUpdates();
                    }
                }
                catch (RemoteException re) {
                    Logger.error((String)"unable to load available plugins", (Throwable)re);
                    Application.getMessagingFactory().sendMessage(new StatusBarMessage(i18n.tr("Laden der verf\u00fcgbaren Plugins fehlgeschlagen"), 1));
                }
            }
        });
        if (folder.getSelection() == itemAvailable) {
            try {
                this.loadAvailable();
                loadedAvailable.set(true);
            }
            catch (RemoteException re) {
                Logger.error((String)"unable to load available plugins", (Throwable)re);
                Application.getMessagingFactory().sendMessage(new StatusBarMessage(i18n.tr("Laden der verf\u00fcgbaren Plugins fehlgeschlagen"), 1));
            }
        }
        SimpleContainer c2 = new SimpleContainer(comp);
        c2.addText("", true);
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(new Button(i18n.tr("Plugin manuell installieren..."), new PluginInstall(), null, false, "emblem-package.png"));
        buttons.addButton(new Button(i18n.tr("Repositories bearbeiten..."), new RepositoryEdit(), null, false, "document-properties.png"));
        buttons.addButton(new Button(i18n.tr("Automatische Updates konfigurieren..."), new UpdateEdit(), null, false, "view-refresh.png"));
        buttons.paint(comp);
        final MessagingFactory mf = Application.getMessagingFactory();
        final List<String> queues = Arrays.asList("jameica.update.repository.add", "jameica.update.repository.remove", "jameica.update.repository.enabled", "jameica.update.repository.disabled");
        for (String s : queues) {
            mf.getMessagingQueue(s).registerMessageConsumer(this.repoNotify);
        }
        mf.registerMessageConsumer(this.pluginNotify);
        comp.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                mf.unRegisterMessageConsumer(PluginListPart.this.pluginNotify);
                for (String s : queues) {
                    mf.getMessagingQueue(s).unRegisterMessageConsumer(PluginListPart.this.repoNotify);
                }
            }
        });
    }

    private void loadInstalled() throws RemoteException {
        Map<String, Manifest> cache = PluginCacheMessageConsumer.getCache();
        this.checkInstalled();
        for (Map.Entry<String, Manifest> e : cache.entrySet()) {
            Manifest mf = cache.get(e.getKey());
            PluginDetailPart part = new PluginDetailPart(mf, PluginDetailPart.Type.INSTALLED);
            this.installedParts.put(e.getKey(), part);
            part.paint(this.installedList.getComposite());
        }
        this.installedList.update();
    }

    private void loadAvailable() throws RemoteException {
        Logger.info((String)"start search for available plugins");
        this.dispose(this.availableList, this.availableParts);
        Placeholder pl = new Placeholder(Placeholder.Style.LOADING);
        pl.setText(i18n.tr("Einen Moment bitte..."));
        pl.paint(this.availableList.getComposite());
        this.availableList.update();
        String repo = (String)this.getRepositories().getValue();
        URL u = null;
        if (repo != null && repo.length() > 0) {
            try {
                u = new URL(repo);
            }
            catch (MalformedURLException e) {
                this.handleAvailableError(e);
                Application.getMessagingFactory().sendMessage(new StatusBarMessage(i18n.tr("URL ung\u00fcltig: {0}", repo), 1));
            }
        }
        final URL url = u;
        final String query = (String)this.getQuery().getValue();
        Thread t = new Thread("repo-fetch available"){

            @Override
            public void run() {
                try {
                    String key = (url != null ? url.toString() : "<all>") + "." + query;
                    List<RepositorySearchResult> cachedResult = (List<RepositorySearchResult>)availableCache.get((Object)key);
                    if (cachedResult != null) {
                        Logger.info((String)"using cached list for available plugins");
                    } else {
                        RepositoryService service = (RepositoryService)Application.getBootLoader().getBootable(RepositoryService.class);
                        cachedResult = service.search(url, query);
                        if (cachedResult == null) {
                            cachedResult = new ArrayList<RepositorySearchResult>();
                        }
                        availableCache.put((Object)key, cachedResult);
                    }
                    final List<RepositorySearchResult> result = cachedResult;
                    final AtomicInteger found = new AtomicInteger(0);
                    for (RepositorySearchResult r : result) {
                        found.addAndGet(r.size());
                    }
                    Logger.info((String)("search done, found " + found + " plugins/version"));
                    GUI.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                PluginListPart.this.dispose(PluginListPart.this.availableList, null);
                                if (found.get() == 0) {
                                    Placeholder empty = new Placeholder(Placeholder.Style.EMPTY);
                                    empty.setTitle(i18n.tr("Keine Plugins gefunden"));
                                    empty.setText(i18n.tr("\u00c4ndern oder entfernen Sie ggf. den Suchbegriff"));
                                    empty.paint(PluginListPart.this.availableList.getComposite());
                                    PluginListPart.this.availableList.update();
                                    return;
                                }
                                for (RepositorySearchResult r : result) {
                                    if (r.getGroups().size() > 0) {
                                        Composite parent = PluginListPart.this.availableList.getComposite();
                                        SimpleContainer c = new SimpleContainer(parent);
                                        c.getComposite().setBackground(parent.getBackground());
                                        c.getComposite().setBackgroundMode(2);
                                        c.addHeadline(r.getRepository().getName());
                                    }
                                    for (PluginGroup group : r.getGroups()) {
                                        TreeMap<String, List<PluginData>> plugins = r.getResult(group);
                                        int count = 0;
                                        for (Map.Entry<String, List<PluginData>> e : plugins.entrySet()) {
                                            List<PluginData> list = e.getValue();
                                            if (list.size() == 0) continue;
                                            ++count;
                                        }
                                        if (count == 0) continue;
                                        Composite parent = PluginListPart.this.availableList.getComposite();
                                        SimpleContainer c = new SimpleContainer(parent);
                                        c.getComposite().setBackground(parent.getBackground());
                                        c.getComposite().setBackgroundMode(2);
                                        c.addText(group.getName(), true);
                                        for (Map.Entry<String, List<PluginData>> e : plugins.entrySet()) {
                                            List<PluginData> list = e.getValue();
                                            if (list.size() == 0) continue;
                                            try {
                                                Manifest mf = list.get(0).getManifest();
                                                PluginDetailPart part = new PluginDetailPart(mf, list, PluginDetailPart.Type.AVAILABLE);
                                                PluginListPart.this.availableParts.put(e.getKey(), part);
                                                part.paint(PluginListPart.this.availableList.getComposite());
                                            }
                                            catch (Exception ex) {
                                                Logger.error((String)"unable to load plugin details, skipping", (Throwable)ex);
                                            }
                                        }
                                    }
                                }
                                PluginListPart.this.availableList.update();
                            }
                            catch (Exception e) {
                                PluginListPart.this.handleAvailableError(e);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    GUI.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            PluginListPart.this.handleAvailableError(e);
                        }
                    });
                }
            }
        };
        t.start();
    }

    private void handleAvailableError(Exception e) {
        String msg = i18n.tr("Repository nicht lesbar");
        if (e instanceof ApplicationException) {
            msg = e.getMessage();
        }
        Logger.error((String)"error while loading repository", (Throwable)e);
        Application.getMessagingFactory().sendMessage(new StatusBarMessage(msg, 1));
        this.dispose(this.availableList, null);
        Placeholder empty = new Placeholder(Placeholder.Style.ERROR);
        empty.setTitle(i18n.tr("Repository nicht lesbar"));
        empty.setText(msg);
        try {
            empty.paint(this.availableList.getComposite());
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to display error", (Throwable)re);
        }
        this.availableList.update();
    }

    private void loadUpdates() throws RemoteException {
        Logger.info((String)"start search for available updates");
        this.dispose(this.updateList, this.updateParts);
        Placeholder pl = new Placeholder(Placeholder.Style.LOADING);
        pl.setText(i18n.tr("Einen Moment bitte..."));
        pl.paint(this.updateList.getComposite());
        this.updateList.update();
        Thread t = new Thread("repo-fetch updates"){

            @Override
            public void run() {
                UpdateService service = (UpdateService)Application.getBootLoader().getBootable(UpdateService.class);
                try {
                    String key = "updates";
                    TreeMap<String, List<PluginData>> cachedUpdates = (TreeMap<String, List<PluginData>>)updateCache.get((Object)"updates");
                    if (cachedUpdates != null) {
                        Logger.info((String)"using cached list for updates");
                    } else {
                        cachedUpdates = service.findUpdates(null);
                        if (cachedUpdates == null) {
                            cachedUpdates = new TreeMap();
                        }
                        updateCache.put((Object)"updates", cachedUpdates);
                    }
                    final TreeMap<String, List<PluginData>> updates = cachedUpdates;
                    Logger.info((String)("search done, found " + (Serializable)(updates != null ? Integer.valueOf(updates.size()) : "no") + " updates"));
                    GUI.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                PluginListPart.this.dispose(PluginListPart.this.updateList, null);
                                if (updates == null || updates.size() == 0) {
                                    Placeholder empty = new Placeholder(Placeholder.Style.DONE);
                                    empty.setTitle(i18n.tr("Keine Updates gefunden"));
                                    empty.setText(i18n.tr("Schauen Sie doch sp\u00e4ter mal wieder vorbei ;)"));
                                    empty.paint(PluginListPart.this.updateList.getComposite());
                                    PluginListPart.this.updateList.update();
                                    return;
                                }
                                for (Map.Entry e : updates.entrySet()) {
                                    List list = (List)e.getValue();
                                    if (list.size() == 0) continue;
                                    Manifest mf = ((PluginData)list.get(0)).getManifest();
                                    PluginDetailPart part = new PluginDetailPart(mf, list, PluginDetailPart.Type.UPDATE);
                                    PluginListPart.this.updateParts.put((String)e.getKey(), part);
                                    part.paint(PluginListPart.this.updateList.getComposite());
                                }
                                PluginListPart.this.updateList.update();
                            }
                            catch (Exception e) {
                                Logger.error((String)"error while loading repository", (Throwable)e);
                                Application.getMessagingFactory().sendMessage(new StatusBarMessage(i18n.tr("Fehler beim Suchen nach Updates: {0}", e.getMessage()), 1));
                            }
                        }
                    });
                }
                catch (ApplicationException ae) {
                    Application.getMessagingFactory().sendMessage(new StatusBarMessage(ae.getMessage(), 1));
                }
                catch (Exception e) {
                    Logger.error((String)"error while loading repository", (Throwable)e);
                    Application.getMessagingFactory().sendMessage(new StatusBarMessage(i18n.tr("Fehler beim Suchen nach Updates: {0}", e.getMessage()), 1));
                }
            }
        };
        t.start();
    }

    private String toTabLabel(String label) {
        return "   " + i18n.tr(label) + "   ";
    }

    private List<String> getRepoList() {
        RepositoryService service = (RepositoryService)Application.getBootLoader().getBootable(RepositoryService.class);
        List<URL> list = service.getRepositories();
        ArrayList<String> urls = new ArrayList<String>();
        for (URL u : list) {
            urls.add(u.toString());
        }
        return urls;
    }

    private SelectInput getRepositories() {
        if (this.repositories != null) {
            return this.repositories;
        }
        this.repositories = new SelectInput(this.getRepoList(), (Object)"https://www.willuhn.de/products/jameica/updates");
        this.repositories.setPleaseChoose(i18n.tr("<Alle Repositories>"));
        this.repositories.addListener(new Listener(){

            public void handleEvent(Event event) {
                try {
                    if (event.type != 13) {
                        return;
                    }
                    PluginListPart.this.loadAvailable();
                }
                catch (RemoteException re) {
                    Logger.error((String)"unable to load available plugins", (Throwable)re);
                    Application.getMessagingFactory().sendMessage(new StatusBarMessage(i18n.tr("Fehler beim Laden der Plugins: {0}", re.getMessage()), 1));
                }
            }
        });
        return this.repositories;
    }

    private QueryInput getQuery() {
        if (this.query != null) {
            return this.query;
        }
        this.query = new QueryInput(100){

            @Override
            public void doSearch(String query) {
                try {
                    PluginListPart.this.loadAvailable();
                }
                catch (RemoteException re) {
                    Logger.error((String)"unable to load available plugins", (Throwable)re);
                    Application.getMessagingFactory().sendMessage(new StatusBarMessage(i18n.tr("Fehler beim Laden der Plugins: {0}", re.getMessage()), 1));
                }
            }
        };
        return this.query;
    }

    private void checkInstalled() throws RemoteException {
        if (PluginCacheMessageConsumer.getCache().size() == 0) {
            this.dispose(this.installedList, null);
            Placeholder pl = new Placeholder(Placeholder.Style.EMPTY);
            pl.setTitle(i18n.tr("Noch keine Plugins installiert"));
            pl.setText(i18n.tr("Klicken Sie auf \"Verf\u00fcgbare Plugins\", um Plugins zu installieren."));
            pl.paint(this.installedList.getComposite());
        }
        this.installedList.update();
    }

    private void dispose(ScrolledContainer c, Map<String, PluginDetailPart> map) {
        try {
            SWTUtil.disposeChildren(c.getComposite());
        }
        finally {
            if (map != null) {
                map.clear();
            }
        }
    }

    private class MyInstalledMessageConsumer
    implements MessageConsumer {
        private MyInstalledMessageConsumer() {
        }

        @Override
        public Class[] getExpectedMessageTypes() {
            return new Class[]{PluginMessage.class};
        }

        @Override
        public void handleMessage(Message message) throws Exception {
            final PluginMessage m = (PluginMessage)message;
            final Manifest mf = m.getManifest();
            if (mf == null) {
                return;
            }
            GUI.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (PluginListPart.this.installedParts.size() == 0) {
                            PluginListPart.this.dispose(PluginListPart.this.installedList, null);
                        }
                        for (Map.Entry<String, PluginDetailPart> e : PluginListPart.this.installedParts.entrySet()) {
                            if (!mf.getName().equals(e.getKey())) continue;
                            e.getValue().dispose();
                        }
                        PluginMessage.Event event = m.getEvent();
                        if (event == PluginMessage.Event.INSTALLED || event == PluginMessage.Event.UPDATED) {
                            PluginDetailPart part = new PluginDetailPart(mf, PluginDetailPart.Type.INSTALLED);
                            PluginListPart.this.installedParts.put(mf.getName(), part);
                            part.paint(PluginListPart.this.installedList.getComposite());
                        }
                        PluginListPart.this.checkInstalled();
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to update plugin list", (Throwable)e);
                    }
                }
            });
        }

        @Override
        public boolean autoRegister() {
            return false;
        }
    }

    private class MyRepoMessageConsumer
    implements MessageConsumer {
        private MyRepoMessageConsumer() {
        }

        @Override
        public Class[] getExpectedMessageTypes() {
            return new Class[]{QueryMessage.class};
        }

        @Override
        public void handleMessage(Message message) throws Exception {
            GUI.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PluginListPart.this.getRepositories().setList(PluginListPart.this.getRepoList());
                }
            });
        }

        @Override
        public boolean autoRegister() {
            return false;
        }
    }
}

