/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.parts;

import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.backup.BackupFile;
import de.willuhn.jameica.gui.formatter.TableFormatter;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.parts.table.FeatureSummary;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.plugin.Manifest;
import de.willuhn.jameica.plugin.Version;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.eclipse.swt.widgets.TableItem;

public class BackupVersionsList
extends TablePart {
    private boolean warning = false;

    public BackupVersionsList(BackupFile backup) throws RemoteException {
        super(null);
        this.setMulti(false);
        this.setRememberColWidths(true);
        this.setRememberOrder(true);
        this.removeFeature(FeatureSummary.class);
        this.addColumn(Application.getI18n().tr("Plugin"), "name");
        this.addColumn(Application.getI18n().tr("Version des Backups"), "backupversion");
        this.addColumn(Application.getI18n().tr("Installierte Version"), "currentversion");
        this.setFormatter(new TableFormatter(){

            @Override
            public void format(TableItem item) {
                Object data = item.getData();
                if (data == null || !(data instanceof Plugin)) {
                    return;
                }
                Plugin p = (Plugin)data;
                if (p.versionMissmatch || p.noBackup) {
                    item.setForeground(Color.ERROR.getSWTColor());
                } else if (p.notInstalled) {
                    item.setForeground(Color.COMMENT.getSWTColor());
                } else {
                    item.setForeground(Color.FOREGROUND.getSWTColor());
                }
            }
        });
        List<Plugin> data = this.init(backup);
        for (int i = 0; i < data.size(); ++i) {
            Plugin p = data.get(i);
            this.warning |= p.versionMissmatch || p.noBackup;
            this.addItem(p);
        }
    }

    public boolean hasWarnings() {
        return this.warning;
    }

    private List<Plugin> init(BackupFile file) {
        List<Manifest> l = Application.getPluginLoader().getInstalledManifests();
        Hashtable<String, Manifest> installed = new Hashtable<String, Manifest>();
        for (Manifest mf2 : l) {
            installed.put(mf2.getPluginId(), mf2);
        }
        Properties props = file.getProperties();
        Enumeration<Object> keys = props.keys();
        ArrayList<Plugin> list = new ArrayList<Plugin>();
        while (keys.hasMoreElements()) {
            String pc2 = (String)keys.nextElement();
            if (pc2 != null && pc2.equals("jameica")) continue;
            if (pc2 == null || !pc2.endsWith(".version")) {
                Logger.warn((String)("invalid plugin " + pc2 + " defined. backup: " + file.getFile().getAbsolutePath()));
                continue;
            }
            String version = props.getProperty(pc2);
            if (version == null || version.length() == 0) {
                Logger.warn((String)("plugin " + pc2 + " defined, but no version number. backup: " + file.getFile().getAbsolutePath()));
                continue;
            }
            pc2 = pc2.substring(0, pc2.lastIndexOf(".version"));
            list.add(new Plugin(pc2, (Manifest)installed.remove(pc2), new Version(version)));
        }
        installed.forEach((pc, mf) -> list.add(new Plugin((String)pc, (Manifest)mf, null)));
        return list;
    }

    private class Plugin
    implements GenericObject {
        private String pluginClass = null;
        private String name = null;
        private Version backupVersion = null;
        private Version currentVersion = null;
        private boolean versionMissmatch = false;
        private boolean noBackup = false;
        private boolean notInstalled = false;

        private Plugin(String pluginClass, Manifest manifest, Version backupVersion) {
            this.pluginClass = pluginClass;
            this.backupVersion = backupVersion;
            this.name = this.pluginClass;
            boolean bl = this.noBackup = this.backupVersion == null;
            if (manifest == null) {
                de.willuhn.jameica.plugin.Plugin plugin = null;
                try {
                    plugin = Application.getPluginLoader().getPlugin(this.pluginClass);
                }
                catch (Exception e) {
                    Logger.warn((String)("unable to find plugin, consider as not-installed: " + e.getMessage()));
                    Logger.write((Level)Level.DEBUG, (String)"stacktrace for debugging purpose", (Throwable)e);
                }
                if (plugin != null) {
                    manifest = plugin.getManifest();
                }
            }
            boolean bl2 = this.notInstalled = manifest == null;
            if (manifest != null) {
                this.name = manifest.getName();
                this.currentVersion = manifest.getVersion();
                this.versionMissmatch = this.backupVersion != null && this.backupVersion.compareTo(this.currentVersion) > 0;
            }
        }

        public boolean equals(GenericObject other) throws RemoteException {
            if (other == null || !(other instanceof Plugin)) {
                return false;
            }
            return this.getID().equals(other.getID());
        }

        public Object getAttribute(String name) throws RemoteException {
            if ("name".equals(name)) {
                return this.name;
            }
            if ("currentversion".equals(name)) {
                return this.currentVersion == null ? Application.getI18n().tr("nicht installiert") : this.currentVersion;
            }
            if ("backupversion".equals(name)) {
                return this.backupVersion == null ? Application.getI18n().tr("nicht enthalten") : this.backupVersion;
            }
            return null;
        }

        public String[] getAttributeNames() throws RemoteException {
            return new String[]{"name", "currentversion", "backupversion"};
        }

        public String getID() throws RemoteException {
            return this.pluginClass;
        }

        public String getPrimaryAttribute() throws RemoteException {
            return "name";
        }
    }
}

