/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.parts;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.View;
import de.willuhn.jameica.gui.parts.Panel;
import de.willuhn.jameica.gui.parts.PanelButton;
import de.willuhn.jameica.gui.parts.ProgressBar;
import de.willuhn.jameica.gui.util.DelayedListener;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.BackgroundTask;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class BackgroundTaskMonitor
extends ProgressBar {
    private static final DateFormat DF = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    private static final AtomicBoolean DEFAULT_LOCKED = new AtomicBoolean(false);
    private static final AtomicLong USAGES = new AtomicLong(0L);
    private DelayedListener delay = null;
    private AtomicBoolean started = new AtomicBoolean(false);
    private AtomicBoolean panelLocked = DEFAULT_LOCKED;
    private AtomicLong usage = new AtomicLong(USAGES.incrementAndGet());
    private StringBuilder logs = new StringBuilder();
    private BackgroundTask task = null;
    private PanelButton cancel = null;

    public BackgroundTaskMonitor() {
        this(null);
    }

    public BackgroundTaskMonitor(BackgroundTask task) {
        this.task = task;
    }

    private synchronized void check() {
        if (this.delay == null) {
            this.delay = new DelayedListener(60000, new Listener(){

                public void handleEvent(Event event) {
                    if (BackgroundTaskMonitor.this.panelLocked.get()) {
                        return;
                    }
                    if (BackgroundTaskMonitor.this.started.get() && BackgroundTaskMonitor.this.isFinalState(event.detail)) {
                        GUI.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!BackgroundTaskMonitor.this.started.get() || !GUI.getView().snappedIn() || BackgroundTaskMonitor.this.usage.get() != USAGES.get()) {
                                    return;
                                }
                                try {
                                    Logger.info((String)"auto closing monitor snapin");
                                    GUI.getView().snapOut();
                                }
                                finally {
                                    BackgroundTaskMonitor.this.started.set(false);
                                }
                            }
                        });
                    }
                }
            });
        }
        Event e = new Event();
        e.detail = this.getStatus();
        this.delay.handleEvent(e);
        if (this.started.get()) {
            return;
        }
        Logger.info((String)"creating progress monitor for GUI");
        GUI.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                final View view = GUI.getView();
                if (view.snappedIn()) {
                    view.snapOut();
                }
                try {
                    I18N i18n = Application.getI18n();
                    Panel panel = new Panel(i18n.tr("Status"), BackgroundTaskMonitor.this, false);
                    panel.addButton(new PanelButton("minimize.png", new Action(){

                        @Override
                        public void handleAction(Object context) throws ApplicationException {
                            Logger.info((String)"closing background task monitor snapin");
                            view.snapOut();
                            BackgroundTaskMonitor.this.started.set(false);
                        }
                    }, Application.getI18n().tr("Minimieren")));
                    panel.addButton(BackgroundTaskMonitor.this.getLockButton());
                    panel.addButton(BackgroundTaskMonitor.this.getCopyButton());
                    if (BackgroundTaskMonitor.this.task != null) {
                        panel.addButton(BackgroundTaskMonitor.this.getCancelButton());
                    }
                    panel.paint(view.getSnapin());
                    Logger.info((String)"activating progress monitor");
                    view.snapIn();
                    BackgroundTaskMonitor.this.started.set(true);
                }
                catch (RemoteException e) {
                    Logger.error((String)"unable to snapin progress monitor", (Throwable)e);
                }
            }
        });
    }

    private boolean isFinalState(int state) {
        return state == 5 || state == 4 || state == 3;
    }

    private PanelButton getLockButton() {
        final PanelButton lockButton = new PanelButton(this.getLockedIcon(), null, Application.getI18n().tr("Fixieren"));
        lockButton.setAction(new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                BackgroundTaskMonitor.this.panelLocked.set(!BackgroundTaskMonitor.this.panelLocked.get());
                DEFAULT_LOCKED.set(BackgroundTaskMonitor.this.panelLocked.get());
                lockButton.setIcon(BackgroundTaskMonitor.this.getLockedIcon());
                if (!BackgroundTaskMonitor.this.panelLocked.get()) {
                    BackgroundTaskMonitor.this.check();
                    Event e = new Event();
                    e.detail = 4;
                    BackgroundTaskMonitor.this.delay.handleEvent(e);
                }
            }
        });
        return lockButton;
    }

    private PanelButton getCopyButton() {
        PanelButton copyButton = new PanelButton("edit-copy.png", null, Application.getI18n().tr("Text kopieren"));
        copyButton.setAction(new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                try {
                    Clipboard cb = new Clipboard(GUI.getDisplay());
                    cb.setContents(new Object[]{BackgroundTaskMonitor.this.logs.toString()}, new Transfer[]{TextTransfer.getInstance()});
                    Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Text in Zwischenablage kopiert."), 0));
                }
                catch (Exception e) {
                    Logger.error((String)"unable to copy text to clipboard", (Throwable)e);
                    Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Fehler beim Kopieren in die Zwischenablage ."), 1));
                }
            }
        });
        return copyButton;
    }

    private String getLockedIcon() {
        return this.panelLocked.get() ? "locked.png" : "unlocked.png";
    }

    private PanelButton getCancelButton() {
        if (this.cancel != null) {
            return this.cancel;
        }
        this.cancel = new PanelButton("process-stop.png", new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                if (BackgroundTaskMonitor.this.task == null || BackgroundTaskMonitor.this.task.isInterrupted()) {
                    return;
                }
                Logger.info((String)"cancel background task");
                BackgroundTaskMonitor.this.task.interrupt();
                BackgroundTaskMonitor.this.cancel.setEnabled(false);
            }
        }, Application.getI18n().tr("Abbrechen"));
        this.cancel.setEnabled(this.task != null && !this.task.isInterrupted());
        return this.cancel;
    }

    @Override
    public void setPercentComplete(int arg0) {
        this.check();
        super.setPercentComplete(arg0);
    }

    @Override
    public void addPercentComplete(int arg0) {
        this.check();
        super.addPercentComplete(arg0);
    }

    @Override
    public int getPercentComplete() {
        this.check();
        return super.getPercentComplete();
    }

    @Override
    public void setStatus(int status) {
        boolean finalState;
        boolean bl = finalState = status == 5 || status == 4 || status == 3;
        if (finalState) {
            this.getCancelButton().setEnabled(false);
        }
        super.setStatus(status);
        this.check();
    }

    @Override
    public void setStatusText(String arg0) {
        this.check();
        super.setStatusText(arg0);
    }

    @Override
    public void log(String arg0) {
        this.check();
        String msg = "[" + DF.format(new Date()) + "] " + arg0;
        if (!msg.endsWith("\n")) {
            msg = msg + "\n";
        }
        this.logs.append(msg);
        super.log(msg);
    }

    @Override
    public void clearLog() {
        this.check();
        super.clearLog();
    }
}

