/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.parts;

import de.willuhn.jameica.attachment.Attachment;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.formatter.Formatter;
import de.willuhn.jameica.gui.internal.action.AttachmentOpen;
import de.willuhn.jameica.gui.internal.menus.AttachmentListContextMenu;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.MessagingQueue;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.services.AttachmentService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;

public class AttachmentListPart
extends TablePart {
    private final DateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm");
    private final I18N i18n = Application.getI18n();

    public AttachmentListPart() throws IOException {
        super(AttachmentListPart.getAttachments(), (Action)new AttachmentOpen());
        this.setContextMenu(new AttachmentListContextMenu());
        this.addColumn(this.i18n.tr("Dateiname"), "filename");
        this.addColumn(this.i18n.tr("Datum"), "date", new Formatter(){

            @Override
            public String format(Object o) {
                if (!(o instanceof Long)) {
                    return "";
                }
                Long l = (Long)o;
                return AttachmentListPart.this.df.format(new Date(l));
            }
        });
        this.setMulti(true);
        this.setRememberColWidths(true);
        this.setRememberOrder(true);
        this.setRememberState(false);
    }

    @Override
    public synchronized void paint(Composite parent) throws RemoteException {
        super.paint(parent);
        final MessagingQueue qAdd = Application.getMessagingFactory().getMessagingQueue("jameica.attachment.added");
        final MessagingQueue qUpd = Application.getMessagingFactory().getMessagingQueue("jameica.attachment.update");
        final MessagingQueue qDel = Application.getMessagingFactory().getMessagingQueue("jameica.attachment.deleted");
        final OnAdd onAdd = new OnAdd();
        final OnDel onDel = new OnDel();
        final OnUpdate onUpd = new OnUpdate();
        qAdd.registerMessageConsumer(onAdd);
        qUpd.registerMessageConsumer(onUpd);
        qDel.registerMessageConsumer(onDel);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                qAdd.unRegisterMessageConsumer(onAdd);
                qUpd.unRegisterMessageConsumer(onUpd);
                qDel.unRegisterMessageConsumer(onDel);
            }
        });
    }

    private static List<Attachment> getAttachments() throws IOException {
        AttachmentService service = (AttachmentService)Application.getBootLoader().getBootable(AttachmentService.class);
        return service.find();
    }

    private class OnAdd
    implements MessageConsumer {
        private OnAdd() {
        }

        @Override
        public Class[] getExpectedMessageTypes() {
            return new Class[]{QueryMessage.class};
        }

        @Override
        public void handleMessage(Message message) throws Exception {
            final QueryMessage m = (QueryMessage)message;
            GUI.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        AttachmentListPart.this.addItem(m.getData());
                        AttachmentListPart.this.sort();
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to add attachment to list", (Throwable)e);
                    }
                }
            });
        }

        @Override
        public boolean autoRegister() {
            return false;
        }
    }

    private class OnDel
    implements MessageConsumer {
        private OnDel() {
        }

        @Override
        public Class[] getExpectedMessageTypes() {
            return new Class[]{QueryMessage.class};
        }

        @Override
        public void handleMessage(Message message) throws Exception {
            final QueryMessage m = (QueryMessage)message;
            GUI.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        AttachmentListPart.this.removeItem(m.getData());
                        AttachmentListPart.this.sort();
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to remove attachment from list", (Throwable)e);
                    }
                }
            });
        }

        @Override
        public boolean autoRegister() {
            return false;
        }
    }

    private class OnUpdate
    implements MessageConsumer {
        private OnUpdate() {
        }

        @Override
        public Class[] getExpectedMessageTypes() {
            return new Class[]{QueryMessage.class};
        }

        @Override
        public void handleMessage(Message message) throws Exception {
            final QueryMessage m = (QueryMessage)message;
            GUI.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        Attachment updated = (Attachment)m.getData();
                        for (Object o : AttachmentListPart.this.getItems()) {
                            if (!(o instanceof Attachment)) continue;
                            Attachment existing = (Attachment)o;
                            if (!Objects.equals(updated.getFilename(), existing.getFilename())) continue;
                            AttachmentListPart.this.removeItem(existing);
                            AttachmentListPart.this.addItem(updated);
                            break;
                        }
                        AttachmentListPart.this.sort();
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to update attachment", (Throwable)e);
                    }
                }
            });
        }

        @Override
        public boolean autoRegister() {
            return false;
        }
    }
}

