/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.menus;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.internal.action.RepositoryAdd;
import de.willuhn.jameica.gui.internal.action.RepositoryDisable;
import de.willuhn.jameica.gui.internal.action.RepositoryEnable;
import de.willuhn.jameica.gui.internal.action.RepositoryRemove;
import de.willuhn.jameica.gui.internal.parts.RepositoryList;
import de.willuhn.jameica.gui.parts.CheckedContextMenuItem;
import de.willuhn.jameica.gui.parts.ContextMenu;
import de.willuhn.jameica.gui.parts.ContextMenuItem;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.I18N;

public class RepositoryListMenu
extends ContextMenu {
    private static final I18N i18n = Application.getI18n();

    public RepositoryListMenu() {
        this.addItem(new SystemCheckedContextMenuItem(i18n.tr("L\u00f6schen..."), new RepositoryRemove(), "user-trash-full.png"));
        this.addItem(ContextMenuItem.SEPARATOR);
        this.addItem(new ChangeStateCheckedContextMenuItem(i18n.tr("Deaktivieren..."), new RepositoryDisable(), "network-offline.png", false));
        this.addItem(new ChangeStateCheckedContextMenuItem(i18n.tr("Aktivieren..."), new RepositoryEnable(), "network-transmit-receive.png", true));
        this.addItem(ContextMenuItem.SEPARATOR);
        this.addItem(new ContextMenuItem(i18n.tr("Neues Repository hinzuf\u00fcgen..."), new RepositoryAdd(), "document-new.png"));
    }

    private class SystemCheckedContextMenuItem
    extends CheckedContextMenuItem {
        public SystemCheckedContextMenuItem(String text, Action a, String icon) {
            super(text, a, icon);
        }

        @Override
        public boolean isEnabledFor(Object o) {
            return super.isEnabledFor(o) && !"https://www.willuhn.de/products/jameica/updates".equalsIgnoreCase(o.toString());
        }
    }

    private class ChangeStateCheckedContextMenuItem
    extends SystemCheckedContextMenuItem {
        private boolean enabled;

        public ChangeStateCheckedContextMenuItem(String text, Action a, String icon, boolean enabled) {
            super(text, a, icon);
            this.enabled = true;
            this.enabled = enabled;
        }

        @Override
        public boolean isEnabledFor(Object o) {
            if (o == null || !(o instanceof RepositoryList.RepositoryEntry)) {
                return false;
            }
            RepositoryList.RepositoryEntry u = (RepositoryList.RepositoryEntry)o;
            return this.enabled != u.isEnabled() && super.isEnabledFor(o);
        }
    }
}

