/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.ext;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.extension.Extendable;
import de.willuhn.jameica.gui.extension.Extension;
import de.willuhn.jameica.gui.formatter.TableFormatter;
import de.willuhn.jameica.gui.internal.views.Settings;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.CheckedSingleContextMenuItem;
import de.willuhn.jameica.gui.parts.ContextMenu;
import de.willuhn.jameica.gui.parts.ContextMenuItem;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.parts.table.FeatureSummary;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.TabGroup;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.MessagingFactory;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.messaging.SettingsChangedMessage;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.services.ScriptingService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.io.File;
import java.rmi.RemoteException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;

public class ScriptingSettingsView
implements Extension {
    private static final I18N i18n = Application.getI18n();
    private static final de.willuhn.jameica.system.Settings settings = new de.willuhn.jameica.system.Settings(ScriptingService.class);
    private ScriptingService service = null;
    private TablePart scripts = null;
    private MessageConsumer mcJameica = new SettingsChangedConsumer();
    private MessageConsumer mcAdded = new AddedConsumer();
    private MessageConsumer mcRemoved = new RemovedConsumer();

    private ScriptingService getService() {
        if (this.service == null) {
            this.service = (ScriptingService)Application.getBootLoader().getBootable(ScriptingService.class);
        }
        return this.service;
    }

    @Override
    public void extend(Extendable extendable) {
        if (extendable == null || !(extendable instanceof Settings)) {
            return;
        }
        final MessagingFactory mf = Application.getMessagingFactory();
        mf.registerMessageConsumer(this.mcJameica);
        mf.getMessagingQueue("jameica.scripting.added").registerMessageConsumer(this.mcAdded);
        mf.getMessagingQueue("jameica.scripting.removed").registerMessageConsumer(this.mcRemoved);
        try {
            Settings settings = (Settings)extendable;
            TabGroup tab = new TabGroup(settings.getTabFolder(), i18n.tr("Scripting"), true);
            tab.addText(i18n.tr("Die registrierten Script-Dateien werden beim Start von Jameica automatisch ausgef\u00fchrt. Sie k\u00f6nnen Funktionen enthalten, die beim Eintreffen bestimmter Ereignisse von Plugins ausgef\u00fchrt werden."), true);
            tab.getComposite().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ScriptingSettingsView.this.scripts = null;
                    mf.unRegisterMessageConsumer(ScriptingSettingsView.this.mcJameica);
                    mf.getMessagingQueue("jameica.scripting.added").unRegisterMessageConsumer(ScriptingSettingsView.this.mcAdded);
                    mf.getMessagingQueue("jameica.scripting.removed").unRegisterMessageConsumer(ScriptingSettingsView.this.mcRemoved);
                }
            });
            tab.addHeadline(i18n.tr("Registrierte Scripts"));
            final TablePart table = this.getScripts();
            tab.addPart(table);
            ButtonArea buttons = new ButtonArea();
            final Button remove = new Button(i18n.tr("Script entfernen..."), new Action(){

                @Override
                public void handleAction(Object context) throws ApplicationException {
                    Object sel = table.getSelection();
                    if (sel != null) {
                        new ActionRemove().handleAction(sel);
                    }
                }
            }, null, false, "user-trash-full.png");
            remove.setEnabled(false);
            table.addSelectionListener(new Listener(){

                public void handleEvent(Event event) {
                    remove.setEnabled(table.getSelection() != null);
                }
            });
            buttons.addButton(remove);
            buttons.addButton(i18n.tr("Script hinzuf\u00fcgen..."), new ActionAdd(), null, false, "document-new.png");
            tab.addButtonArea(buttons);
        }
        catch (Exception e) {
            Logger.error((String)"unable to extend settings", (Throwable)e);
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(i18n.tr("Fehler beim Anzeigen der Scripting-Einstellungen"), 1));
        }
    }

    private void handleStore() throws ApplicationException {
        try {
            this.getService().reload();
        }
        catch (Exception e) {
            Logger.error((String)"unable to restart scripting service", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler beim Laden der Scripts: {0}", e.getMessage()));
        }
    }

    private TablePart getScripts() throws RemoteException {
        if (this.scripts != null) {
            return this.scripts;
        }
        this.scripts = new TablePart(this.getService().getScripts(), null);
        this.scripts.setMulti(false);
        this.scripts.setRememberColWidths(true);
        this.scripts.setRememberOrder(true);
        this.scripts.removeFeature(FeatureSummary.class);
        this.scripts.addColumn(i18n.tr("Script-Datei"), "absolutePath");
        this.scripts.setFormatter(new TableFormatter(){

            @Override
            public void format(TableItem item) {
                if (item == null) {
                    return;
                }
                File f = (File)item.getData();
                if (!(f.canRead() && f.isFile() && f.exists())) {
                    item.setForeground(Color.ERROR.getSWTColor());
                    item.setText(f.getAbsolutePath() + " (" + i18n.tr("Datei nicht lesbar") + ")");
                } else {
                    item.setForeground(Color.FOREGROUND.getSWTColor());
                }
            }
        });
        ContextMenu menu = new ContextMenu();
        menu.addItem(new ItemAdd());
        menu.addItem(new ItemRemove());
        this.scripts.setContextMenu(menu);
        return this.scripts;
    }

    private class SettingsChangedConsumer
    implements MessageConsumer {
        private SettingsChangedConsumer() {
        }

        @Override
        public void handleMessage(Message message) throws Exception {
            ScriptingSettingsView.this.handleStore();
        }

        @Override
        public Class[] getExpectedMessageTypes() {
            return new Class[]{SettingsChangedMessage.class};
        }

        @Override
        public boolean autoRegister() {
            return false;
        }
    }

    private class AddedConsumer
    implements MessageConsumer {
        private AddedConsumer() {
        }

        @Override
        public Class[] getExpectedMessageTypes() {
            return new Class[]{QueryMessage.class};
        }

        @Override
        public void handleMessage(Message message) throws Exception {
            QueryMessage msg = (QueryMessage)message;
            final Object o = msg.getData();
            if (!(o instanceof File)) {
                return;
            }
            GUI.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        ScriptingSettingsView.this.getScripts().addItem(o);
                    }
                    catch (Exception e) {
                        Logger.error((String)("error while adding script " + o));
                        Application.getMessagingFactory().sendMessage(new StatusBarMessage(i18n.tr("Hinzuf\u00fcgen des Scripts fehlgeschlagen"), 1));
                    }
                }
            });
        }

        @Override
        public boolean autoRegister() {
            return false;
        }
    }

    private class RemovedConsumer
    implements MessageConsumer {
        private RemovedConsumer() {
        }

        @Override
        public Class[] getExpectedMessageTypes() {
            return new Class[]{QueryMessage.class};
        }

        @Override
        public void handleMessage(Message message) throws Exception {
            QueryMessage msg = (QueryMessage)message;
            final Object o = msg.getData();
            if (!(o instanceof File)) {
                return;
            }
            GUI.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        ScriptingSettingsView.this.getScripts().removeItem(o);
                    }
                    catch (Exception e) {
                        Logger.error((String)("error while removing script " + o));
                        Application.getMessagingFactory().sendMessage(new StatusBarMessage(i18n.tr("Entfernen des Scripts fehlgeschlagen"), 1));
                    }
                }
            });
        }

        @Override
        public boolean autoRegister() {
            return false;
        }
    }

    private class ActionAdd
    implements Action {
        private ActionAdd() {
        }

        @Override
        public void handleAction(Object context) throws ApplicationException {
            FileDialog dialog = new FileDialog(GUI.getShell(), 4096);
            dialog.setFilterExtensions(new String[]{"*.js"});
            dialog.setFilterPath(settings.getString("lastdir", System.getProperty("user.home")));
            dialog.setText(i18n.tr("Bitte w\u00e4hlen Sie die Script-Datei aus"));
            String s = dialog.open();
            if (s == null || s.length() == 0) {
                return;
            }
            File file = new File(s);
            if (!(file.isFile() && file.canRead() && file.exists())) {
                throw new ApplicationException(i18n.tr("Datei {0} nicht lesbar", s));
            }
            settings.setAttribute("lastdir", file.getParent());
            ScriptingSettingsView.this.getService().addScript(file);
        }
    }

    private class ItemAdd
    extends ContextMenuItem {
        public ItemAdd() {
            super(i18n.tr("Script hinzuf\u00fcgen..."), new ActionAdd(), "document-new.png");
        }
    }

    private class ItemRemove
    extends CheckedSingleContextMenuItem {
        public ItemRemove() {
            super(i18n.tr("Script entfernen..."), new ActionRemove(), "user-trash-full.png");
        }
    }

    private class ActionRemove
    implements Action {
        private ActionRemove() {
        }

        @Override
        public void handleAction(Object context) throws ApplicationException {
            if (context == null || !(context instanceof File)) {
                return;
            }
            try {
                if (!Application.getCallback().askUser(i18n.tr("Sicher?"))) {
                    return;
                }
                ScriptingSettingsView.this.getService().removeScript((File)context);
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (Exception e) {
                Logger.error((String)"error while removing script from table", (Throwable)e);
                Application.getMessagingFactory().sendMessage(new StatusBarMessage(i18n.tr("Fehler beim Entfernen des Scripts: {0}", e.getMessage()), 1));
            }
        }
    }
}

