/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.input.SpinnerInput;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.services.UpdateService;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class UpdateEditDialog
extends AbstractDialog<Void> {
    private static final int WINDOW_WIDTH = 460;
    private CheckboxInput updateCheck = null;
    private SpinnerInput updateInterval = null;
    private SelectInput updateInstall = null;
    private UpdateService service = null;

    public UpdateEditDialog(int position) {
        super(position);
        this.setTitle(this.i18n.tr("Automatische Updates konfigurieren"));
        this.setSize(460, -1);
    }

    @Override
    protected void paint(Composite parent) throws Exception {
        SimpleContainer c = new SimpleContainer(parent);
        c.addText(this.i18n.tr("Aktivieren Sie die automatische Suche nach Updates, wenn Jameica regelm\u00e4\u00dfig pr\u00fcfen soll, ob zu den installierten Plugins neue Updates verf\u00fcgbar sind."), true);
        c.addInput(this.getUpdateCheck());
        c.addInput(this.getUpdateInterval());
        c.addInput(this.getUpdateInstall());
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(this.i18n.tr("\u00dcbernehmen"), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                UpdateEditDialog.this.handleStore();
                UpdateEditDialog.this.close();
            }
        }, null, false, "document-save.png");
        buttons.addButton(this.i18n.tr("Schlie\u00dfen"), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                UpdateEditDialog.this.close();
            }
        }, null, false, "window-close.png");
        c.addButtonArea(buttons);
        this.getShell().setMinimumSize(this.getShell().computeSize(460, -1));
    }

    private CheckboxInput getUpdateCheck() {
        if (this.updateCheck == null) {
            Listener l = new Listener(){

                public void handleEvent(Event event) {
                    Boolean b = (Boolean)UpdateEditDialog.this.getUpdateCheck().getValue();
                    UpdateEditDialog.this.getUpdateInstall().setEnabled(b);
                    UpdateEditDialog.this.getUpdateInterval().setEnabled(b);
                }
            };
            this.updateCheck = new CheckboxInput(this.getUpdateService().getUpdateCheck());
            this.updateCheck.setName(Application.getI18n().tr("Automatisch nach Updates von installierten Plugins suchen"));
            this.updateCheck.addListener(l);
            l.handleEvent(null);
        }
        return this.updateCheck;
    }

    private SpinnerInput getUpdateInterval() {
        if (this.updateInterval == null) {
            this.updateInterval = new SpinnerInput(1, 365, this.getUpdateService().getUpdateInterval());
            this.updateInterval.setComment(Application.getI18n().tr("Tage"));
            this.updateInterval.setMandatory(true);
            this.updateInterval.setName(Application.getI18n().tr("Nach Updates suchen alle"));
        }
        return this.updateInterval;
    }

    private SelectInput getUpdateInstall() {
        if (this.updateInstall == null) {
            I18N i18n = Application.getI18n();
            ArrayList<Option> values = new ArrayList<Option>();
            values.add(new Option(false, i18n.tr("Nur benachrichtigen")));
            values.add(new Option(true, i18n.tr("Automatisch herunterladen und installieren")));
            this.updateInstall = new SelectInput(values, (Object)new Option(this.getUpdateService().getUpdateInstall(), null));
            this.updateInstall.setName(i18n.tr("Wenn Updates vorhanden sind"));
            this.updateInstall.setMandatory(true);
        }
        return this.updateInstall;
    }

    private UpdateService getUpdateService() {
        if (this.service == null) {
            this.service = (UpdateService)Application.getBootLoader().getBootable(UpdateService.class);
        }
        return this.service;
    }

    private void handleStore() {
        UpdateService service = this.getUpdateService();
        service.setUpdateCheck((Boolean)this.getUpdateCheck().getValue());
        service.setUpdateInterval((Integer)this.getUpdateInterval().getValue());
        Option action = (Option)this.getUpdateInstall().getValue();
        service.setUpdateInstall(action.value);
    }

    @Override
    protected Void getData() throws Exception {
        return null;
    }

    private class Option {
        private boolean value;
        private String text;

        private Option(boolean value, String text) {
            this.value = value;
            this.text = text;
        }

        public String toString() {
            return this.text;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Option)) {
                return false;
            }
            return this.value == ((Option)obj).value;
        }
    }
}

