/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.dialogs;

import de.willuhn.jameica.attachment.storage.StorageProvider;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.SelectInput;
import de.willuhn.jameica.gui.internal.buttons.Cancel;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.services.AttachmentService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import org.eclipse.swt.widgets.Composite;

public class StorageProviderDialog
extends AbstractDialog<StorageProvider> {
    final int WINDOW_WIDTH = 470;
    private static final I18N i18n = Application.getI18n();
    private static final Settings settings = new Settings(StorageProviderDialog.class);
    private AttachmentService service = (AttachmentService)Application.getBootLoader().getBootable(AttachmentService.class);
    private StorageProvider selection = null;

    public StorageProviderDialog(int position) {
        super(position);
        this.setTitle(i18n.tr("Speicherort f\u00fcr Dateianh\u00e4nge"));
        this.setSize(470, -1);
        this.selection = this.service.getProvider(settings.getString("selected", null));
    }

    @Override
    protected void paint(Composite parent) throws Exception {
        SimpleContainer container = new SimpleContainer(parent, true);
        container.addText(i18n.tr("Bitte w\u00e4hlen Sie den zu verwendenden Speicherort."), true);
        final SelectInput select = new SelectInput(this.service.getProviders(), (Object)this.selection);
        select.setAttribute("name");
        container.addInput(select);
        final CheckboxInput save = new CheckboxInput(false);
        save.setName(i18n.tr("Diese Frage k\u00fcnftig nicht mehr anzeigen"));
        container.addInput(save);
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(i18n.tr("\u00dcbernehmen"), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                StorageProviderDialog.this.selection = (StorageProvider)select.getValue();
                if (((Boolean)save.getValue()).booleanValue()) {
                    settings.setAttribute("selected", StorageProviderDialog.this.selection != null ? StorageProviderDialog.this.selection.getId() : null);
                }
                StorageProviderDialog.this.close();
            }
        }, null, true, "ok.png");
        buttons.addButton(new Cancel());
        container.addButtonArea(buttons);
        this.getShell().setMinimumSize(this.getShell().computeSize(470, -1));
    }

    public StorageProvider getSaved() {
        return this.selection;
    }

    @Override
    protected StorageProvider getData() throws Exception {
        return this.selection;
    }
}

