/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.calendar.ReminderAppointment;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.input.TextAreaInput;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.Container;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.reminder.Reminder;
import de.willuhn.jameica.reminder.ReminderStorageProvider;
import de.willuhn.jameica.services.ReminderService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.io.Serializable;
import java.util.Calendar;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;

public class ReminderAppointmentDialog
extends AbstractDialog<ReminderAppointment> {
    private ReminderAppointment appointment = null;

    public ReminderAppointmentDialog(int position, ReminderAppointment appointment) {
        super(position);
        this.appointment = appointment;
        String title = this.appointment.getUid() == null ? "Erinnerung anlegen" : "Erinnerung bearbeiten";
        this.setTitle(Application.getI18n().tr(title));
        this.setSize(440, 400);
    }

    @Override
    protected ReminderAppointment getData() throws Exception {
        return this.appointment;
    }

    @Override
    protected void paint(Composite parent) throws Exception {
        final I18N i18n = Application.getI18n();
        final Reminder reminder = this.appointment.getReminder();
        boolean canChange = reminder.getReminderInterval() != null || reminder.getData("jameica.reminder.key.executed") == null;
        Calendar c = Calendar.getInstance(Application.getConfig().getLocale());
        c.setTime(reminder.getDate());
        SimpleContainer container1 = new SimpleContainer(parent, false, 1);
        final DateTime cal = new DateTime(((Container)container1).getComposite(), 25166848);
        cal.setDate(c.get(1), c.get(2), c.get(5));
        cal.setLayoutData((Object)new GridData(768));
        cal.setEnabled(canChange);
        SimpleContainer container2 = new SimpleContainer(parent, true);
        final TextInput name = new TextInput((String)((Object)reminder.getData("key.name")));
        name.setName(i18n.tr("Text"));
        name.setMandatory(true);
        name.setEnabled(canChange);
        container2.addInput(name);
        final TextAreaInput desc = new TextAreaInput((String)((Object)reminder.getData("key.description")));
        desc.setName(i18n.tr("Beschreibung"));
        desc.setEnabled(canChange);
        container2.addInput(desc);
        final LabelInput comment = new LabelInput("");
        comment.setColor(Color.ERROR);
        container2.addInput(comment);
        ButtonArea buttons = new ButtonArea();
        Button apply = new Button(Application.getI18n().tr("\u00dcbernehmen"), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                String s = (String)name.getValue();
                if (StringUtils.trimToNull((String)s) == null) {
                    comment.setValue(Application.getI18n().tr("Bitte geben Sie einen Text ein."));
                    return;
                }
                Calendar c = Calendar.getInstance();
                c.set(1, cal.getYear());
                c.set(2, cal.getMonth());
                c.set(5, cal.getDay());
                c.set(10, 0);
                c.set(12, 0);
                c.set(13, 0);
                c.set(14, 0);
                reminder.setDate(c.getTime());
                reminder.setData("key.name", (Serializable)((Object)s));
                reminder.setData("key.description", (Serializable)((Object)((String)desc.getValue())));
                ReminderAppointmentDialog.this.close();
            }
        }, null, true, "ok.png");
        apply.setEnabled(canChange);
        buttons.addButton(apply);
        Button delete = new Button(Application.getI18n().tr("Termin l\u00f6schen"), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                try {
                    if (!Application.getCallback().askUser(i18n.tr("Sind Sie sicher, dass Sie die Erinnerung l\u00f6schen m\u00f6chten?"))) {
                        return;
                    }
                    ReminderService service = (ReminderService)Application.getBootLoader().getBootable(ReminderService.class);
                    ReminderStorageProvider provider = service.getDefaultProvider();
                    provider.delete(ReminderAppointmentDialog.this.appointment.getUid());
                    ReminderAppointmentDialog.this.appointment = null;
                    ReminderAppointmentDialog.this.close();
                    Application.getMessagingFactory().sendMessage(new StatusBarMessage(i18n.tr("Erinnerung gel\u00f6scht"), 0));
                }
                catch (ApplicationException ae) {
                    throw ae;
                }
                catch (Exception e) {
                    Logger.error((String)"unable to delete appointment", (Throwable)e);
                    throw new ApplicationException(i18n.tr("Fehlgeschlagen: {0}", e.getMessage()));
                }
            }
        }, null, false, "user-trash-full.png");
        delete.setEnabled(this.appointment.getUid() != null);
        buttons.addButton(delete);
        buttons.addButton(Application.getI18n().tr("Abbrechen"), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                throw new OperationCanceledException();
            }
        }, null, false, "process-stop.png");
        container2.addButtonArea(buttons);
    }
}

