/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.formatter.Formatter;
import de.willuhn.jameica.gui.internal.buttons.Cancel;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.parts.table.FeatureSummary;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.update.PluginData;
import de.willuhn.jameica.update.PluginGroup;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.List;
import org.eclipse.swt.widgets.Composite;

public class DependencyDownloadDialog
extends AbstractDialog {
    private static final I18N i18n = Application.getI18n();
    private List<PluginData> data;

    public DependencyDownloadDialog(int position, List<PluginData> data) {
        super(position);
        this.data = data;
        this.setTitle(i18n.tr("Zu installierende Abh\u00e4ngigkeiten"));
        this.setSize(460, 300);
    }

    protected Object getData() throws Exception {
        return null;
    }

    @Override
    protected void paint(Composite parent) throws Exception {
        SimpleContainer container = new SimpleContainer(parent, true);
        container.addText(i18n.tr("Das Plugin ben\u00f6tigt noch weitere abh\u00e4ngige Plugins, die noch nicht (oder nicht in der passenden Version) installiert sind. Sie werden automatisch ebenfalls mit heruntergeladen und installiert."), true);
        TablePart deps = new TablePart(this.data, null);
        deps.addColumn(i18n.tr("Name des Plugins"), "name");
        deps.addColumn(i18n.tr("Version"), "availableVersion");
        deps.addColumn(i18n.tr("Installation von"), "pluginGroup", new Formatter(){

            @Override
            public String format(Object o) {
                if (!(o instanceof PluginGroup)) {
                    return "";
                }
                PluginGroup g = (PluginGroup)o;
                return g.getName() + " (" + g.getRepository().getUrl() + ")";
            }
        });
        deps.setMulti(false);
        deps.setRememberColWidths(false);
        deps.setRememberOrder(true);
        deps.removeFeature(FeatureSummary.class);
        container.addPart(deps);
        container.addText("\n" + i18n.tr("Sind Sie sicher, da\u00df Sie das Plugin und die genannten Abh\u00e4ngigkeiten jetzt herunterladen und installieren m\u00f6chten?"), true);
        ButtonArea buttons = new ButtonArea();
        buttons.addButton("   " + i18n.tr("Ja   "), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                DependencyDownloadDialog.this.close();
            }
        }, null, true, "ok.png");
        buttons.addButton(new Cancel());
        container.addButtonArea(buttons);
    }
}

