/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.dialogs;

import de.willuhn.jameica.bookmark.Bookmark;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.internal.action.BookmarkDelete;
import de.willuhn.jameica.gui.internal.buttons.Cancel;
import de.willuhn.jameica.gui.internal.parts.BookmarkTreePart;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.DelayedListener;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class BookmarkSearchDialog
extends AbstractDialog {
    private static final int WINDOW_WIDTH = 550;
    private Bookmark chosen = null;
    private BookmarkTreePart tree = null;
    private TextInput search = null;

    public BookmarkSearchDialog() {
        super(1);
        this.setSize(550, 400);
        this.setTitle(Application.getI18n().tr("Lesezeichen"));
    }

    protected Object getData() throws Exception {
        return this.chosen;
    }

    @Override
    protected void paint(Composite parent) throws Exception {
        SimpleContainer container = new SimpleContainer(parent, true);
        this.search = new TextInput(null, 100);
        this.search.setName(Application.getI18n().tr("Suchbegriff"));
        this.tree = new BookmarkTreePart(new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                if (!(context instanceof Bookmark)) {
                    return;
                }
                BookmarkSearchDialog.this.chosen = (Bookmark)context;
                BookmarkSearchDialog.this.close();
            }
        });
        container.addInput(this.search);
        container.addPart(this.tree);
        this.search.getControl().addKeyListener((KeyListener)new DelayedAdapter());
        this.search.focus();
        final Button apply = new Button(Application.getI18n().tr("\u00d6ffnen"), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                Object sel = BookmarkSearchDialog.this.tree.getSelection();
                if (!(sel instanceof Bookmark)) {
                    return;
                }
                BookmarkSearchDialog.this.chosen = (Bookmark)sel;
                BookmarkSearchDialog.this.close();
            }
        }, null, true, "ok.png");
        apply.setEnabled(false);
        final Button delete = new Button(Application.getI18n().tr("L\u00f6schen..."), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                Object sel = BookmarkSearchDialog.this.tree.getSelection();
                if (!(sel instanceof Bookmark)) {
                    return;
                }
                new BookmarkDelete().handleAction(sel);
                BookmarkSearchDialog.this.tree.update((String)BookmarkSearchDialog.this.search.getValue());
            }
        }, null, true, "user-trash-full.png");
        delete.setEnabled(false);
        this.tree.addSelectionListener(new Listener(){

            public void handleEvent(Event event) {
                boolean b = event.data instanceof Bookmark;
                apply.setEnabled(b);
                delete.setEnabled(b);
            }
        });
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(apply);
        buttons.addButton(delete);
        buttons.addButton(new Cancel());
        container.addButtonArea(buttons);
        this.getShell().setMinimumSize(this.getShell().computeSize(550, 400));
    }

    private class DelayedAdapter
    extends KeyAdapter {
        private Listener forward = new DelayedListener(300, new Listener(){

            public void handleEvent(Event event) {
                try {
                    BookmarkSearchDialog.this.tree.update((String)BookmarkSearchDialog.this.search.getValue());
                }
                catch (ApplicationException ae) {
                    Application.getMessagingFactory().sendMessage(new StatusBarMessage(ae.getMessage(), 1));
                }
            }
        });

        private DelayedAdapter() {
        }

        public void keyReleased(KeyEvent e) {
            this.forward.handleEvent(null);
        }
    }
}

