/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.dialogs;

import de.willuhn.jameica.attachment.storage.StorageProviderLocal;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.DirectoryInput;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.internal.buttons.Cancel;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.services.AttachmentService;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.io.File;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class AttachmentSettingsDialog
extends AbstractDialog {
    final int WINDOW_WIDTH = 470;
    private static final I18N i18n = Application.getI18n();
    private AttachmentService service = (AttachmentService)Application.getBootLoader().getBootable(AttachmentService.class);
    private StorageProviderLocal storage = null;
    private CheckboxInput check = null;
    private DirectoryInput dir = null;
    private Listener listener = new MyListener();

    public AttachmentSettingsDialog(int position) {
        super(position);
        this.setTitle(i18n.tr("Einstellungen f\u00fcr Dateianh\u00e4nge"));
        this.setSize(470, -1);
        BeanService bs = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        this.storage = bs.get(StorageProviderLocal.class);
    }

    @Override
    protected void paint(Composite parent) throws Exception {
        SimpleContainer container = new SimpleContainer(parent, true);
        if (this.service.getProviders().size() > 1) {
            container.addText(i18n.tr("Dateianh\u00e4nge werden in diesem Ordner gespeichert, wenn Sie die Speicherung in lokalen Dateien ausw\u00e4hlen:"), true);
        } else {
            container.addText(i18n.tr("Dateianh\u00e4nge werden in diesem Ordner gespeichert:"), true);
        }
        container.addText(this.storage.getBaseDir().getAbsolutePath(), true, Color.SUCCESS);
        container.addSeparator();
        container.addText(i18n.tr("Sie k\u00f6nnen optional einen abweichenden Ordner f\u00fcr die Speicherung der Dateianh\u00e4nge w\u00e4hlen."), true);
        container.addInput(this.getCheck());
        container.addInput(this.getDirectory());
        this.listener.handleEvent(null);
        final LabelInput errors = new LabelInput("");
        errors.setColor(Color.ERROR);
        container.addInput(errors);
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(i18n.tr("\u00dcbernehmen"), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                boolean custom = (Boolean)AttachmentSettingsDialog.this.getCheck().getValue();
                AttachmentSettingsDialog.this.storage.useCustomBaseDir(custom);
                String newDir = (String)AttachmentSettingsDialog.this.dir.getValue();
                File test = new File(newDir);
                if (!(!custom || test.exists() && test.isDirectory() && test.canWrite())) {
                    errors.setValue(i18n.tr("Sie besitzen keine Schreibrechte in diesem Ordner"));
                    return;
                }
                AttachmentSettingsDialog.this.storage.setCustomBaseDir(newDir);
                AttachmentSettingsDialog.this.close();
            }
        }, null, true, "ok.png");
        buttons.addButton(new Cancel());
        container.addButtonArea(buttons);
        this.getShell().setMinimumSize(this.getShell().computeSize(470, -1));
    }

    private CheckboxInput getCheck() {
        if (this.check != null) {
            return this.check;
        }
        this.check = new CheckboxInput(this.storage.useCustomBaseDir());
        this.check.setName(i18n.tr("Abweichenden benutzerspezifischen Ordner verwenden"));
        this.check.addListener(this.listener);
        return this.check;
    }

    private DirectoryInput getDirectory() {
        if (this.dir != null) {
            return this.dir;
        }
        this.dir = new DirectoryInput(this.storage.getCustomBaseDir());
        this.dir.setName(i18n.tr("Benutzer-Ordner"));
        return this.dir;
    }

    protected Object getData() throws Exception {
        return null;
    }

    private class MyListener
    implements Listener {
        private MyListener() {
        }

        public void handleEvent(Event event) {
            AttachmentSettingsDialog.this.getDirectory().setEnabled((Boolean)AttachmentSettingsDialog.this.getCheck().getValue());
        }
    }
}

