/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.controller;

import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.pseudo.PseudoIterator;
import de.willuhn.jameica.backup.BackupEngine;
import de.willuhn.jameica.backup.BackupFile;
import de.willuhn.jameica.gui.AbstractControl;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.formatter.CurrencyFormatter;
import de.willuhn.jameica.gui.formatter.DateFormatter;
import de.willuhn.jameica.gui.formatter.Formatter;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.DirectoryInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.SpinnerInput;
import de.willuhn.jameica.gui.internal.action.FileClose;
import de.willuhn.jameica.gui.internal.dialogs.BackupRestoreDialog;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.CheckedContextMenuItem;
import de.willuhn.jameica.gui.parts.ContextMenu;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.parts.table.FeatureSummary;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Config;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.io.File;
import java.rmi.RemoteException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;

public class BackupControl
extends AbstractControl {
    private CheckboxInput state = null;
    private Input target = null;
    private SpinnerInput count = null;
    private TablePart backups = null;
    private Button restore = null;
    private Button selectedRestore = null;

    public BackupControl(AbstractView view) {
        super(view);
    }

    public CheckboxInput getState() {
        if (this.state != null) {
            return this.state;
        }
        this.state = new CheckboxInput(Application.getConfig().getUseBackup());
        this.state.addListener(new Listener(){

            public void handleEvent(Event event) {
                try {
                    boolean b = (Boolean)BackupControl.this.state.getValue();
                    BackupControl.this.getTarget().setEnabled(b);
                    BackupControl.this.getCount().setEnabled(b);
                }
                catch (ApplicationException ae) {
                    Application.getMessagingFactory().sendMessage(new StatusBarMessage(ae.getMessage(), 1));
                }
            }
        });
        return this.state;
    }

    public Input getTarget() throws ApplicationException {
        if (this.target != null) {
            return this.target;
        }
        this.target = new DirectoryInput(Application.getConfig().getBackupDir());
        this.target.setEnabled(Application.getConfig().getUseBackup());
        this.target.addListener(new Listener(){

            public void handleEvent(Event event) {
                try {
                    TablePart table = BackupControl.this.getBackups();
                    table.removeAll();
                    BackupFile[] items = BackupEngine.getBackups((String)BackupControl.this.getTarget().getValue());
                    for (int i = 0; i < items.length; ++i) {
                        table.addItem(items[i]);
                    }
                }
                catch (ApplicationException ae) {
                    Application.getMessagingFactory().sendMessage(new StatusBarMessage(ae.getMessage(), 1));
                }
                catch (RemoteException re) {
                    Logger.error((String)"error while reloading backup list", (Throwable)re);
                    Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Fehler beim Neuladen der Backups"), 1));
                }
            }
        });
        return this.target;
    }

    public Input getCount() {
        if (this.count != null) {
            return this.count;
        }
        this.count = new SpinnerInput(1, 100, Application.getConfig().getBackupCount());
        this.count.setEnabled(Application.getConfig().getUseBackup());
        return this.count;
    }

    public TablePart getBackups() throws RemoteException, ApplicationException {
        if (this.backups != null) {
            return this.backups;
        }
        final CurrencyFormatter format = new CurrencyFormatter("MB", null);
        this.backups = new TablePart(PseudoIterator.fromArray((GenericObject[])BackupEngine.getBackups((String)this.getTarget().getValue())), null);
        this.backups.addColumn(Application.getI18n().tr("Dateiname"), "name");
        this.backups.addColumn(Application.getI18n().tr("Erstellt am"), "created", new DateFormatter(null));
        this.backups.addColumn(Application.getI18n().tr("Gr\u00f6\u00dfe"), "size", new Formatter(){

            @Override
            public String format(Object o) {
                if (o == null || !(o instanceof Number)) {
                    return "-";
                }
                long size = ((Number)o).longValue();
                if (size == 0L) {
                    return "-";
                }
                return format.format((double)size / 1024.0 / 1024.0);
            }
        });
        this.backups.setMulti(false);
        this.backups.setRememberColWidths(true);
        this.backups.setRememberOrder(false);
        this.backups.removeFeature(FeatureSummary.class);
        this.backups.addSelectionListener(new Listener(){

            public void handleEvent(Event event) {
                BackupControl.this.getSelectedRestoreButton().setEnabled(BackupControl.this.backups.getSelection() != null);
            }
        });
        ContextMenu ctx = new ContextMenu();
        ctx.addItem(new CheckedContextMenuItem(Application.getI18n().tr("Backup wiederherstellen..."), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                BackupControl.this.handleSelectedRestore();
            }
        }, "edit-undo.png"));
        this.backups.setContextMenu(ctx);
        return this.backups;
    }

    public Button getRestoreButton() {
        if (this.restore != null) {
            return this.restore;
        }
        this.restore = new Button(Application.getI18n().tr("Anderes Backup wiederherstellen..."), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                FileDialog dialog = new FileDialog(GUI.getShell(), 4096);
                dialog.setFilterExtensions(new String[]{"*.zip"});
                dialog.setText(Application.getI18n().tr("Bitte w\u00e4hlen Sie die Datei aus"));
                String f = dialog.open();
                if (StringUtils.isEmpty((String)f)) {
                    return;
                }
                File file = new File(f);
                if (!(file.exists() && file.canRead() && file.isFile())) {
                    throw new ApplicationException(Application.getI18n().tr("Backup-Datei nicht lesbar"));
                }
                BackupFile bf = new BackupFile(file);
                BackupControl.this.handleRestore(bf);
            }
        }, null, false, "document-open.png");
        return this.restore;
    }

    public Button getSelectedRestoreButton() {
        if (this.selectedRestore != null) {
            return this.selectedRestore;
        }
        this.selectedRestore = new Button(Application.getI18n().tr("Ausgew\u00e4hltes Backup wiederherstellen..."), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                BackupControl.this.handleSelectedRestore();
            }
        }, null, false, "edit-undo.png");
        this.selectedRestore.setEnabled(false);
        return this.selectedRestore;
    }

    public void handleStore() {
        Config config = Application.getConfig();
        try {
            Integer i = (Integer)this.getCount().getValue();
            config.setBackupCount(i == null ? -1 : i);
            this.getCount().setValue(config.getBackupCount());
            config.setBackupDir((String)this.getTarget().getValue());
            this.getTarget().setValue(config.getBackupDir());
            config.setUseBackup((Boolean)this.getState().getValue());
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Einstellungen gespeichert"), 0));
        }
        catch (ApplicationException ae) {
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(ae.getMessage(), 1));
        }
    }

    public void handleSelectedRestore() {
        try {
            this.handleRestore((BackupFile)this.getBackups().getSelection());
        }
        catch (ApplicationException ae) {
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(ae.getMessage(), 1));
        }
        catch (Exception e) {
            Logger.error((String)"unable to choose backup file", (Throwable)e);
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Fehler beim Aktivieren der Backup-Datei"), 1));
        }
    }

    public void handleRestore(BackupFile file) {
        if (file == null) {
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Bitte w\u00e4hlen Sie das wiederherzustellende Backup aus"), 1));
            return;
        }
        try {
            BackupRestoreDialog d = new BackupRestoreDialog(1, file);
            Boolean b = (Boolean)d.open();
            if (!b.booleanValue()) {
                return;
            }
            BackupEngine.markForRestore(file);
            new FileClose().handleAction(null);
        }
        catch (OperationCanceledException oce) {
            Logger.info((String)oce.getMessage());
            return;
        }
        catch (ApplicationException ae) {
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(ae.getMessage(), 1));
        }
        catch (Exception e) {
            Logger.error((String)"unable to choose backup file", (Throwable)e);
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Fehler beim Aktivieren der Backup-Datei"), 1));
        }
    }
}

