/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.action;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.calendar.ReminderAppointment;
import de.willuhn.jameica.gui.internal.dialogs.ReminderAppointmentDialog;
import de.willuhn.jameica.reminder.Reminder;
import de.willuhn.jameica.reminder.ReminderStorageProvider;
import de.willuhn.jameica.services.ReminderService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;

public class ReminderAppointmentDetails
implements Action {
    @Override
    public void handleAction(Object context) throws ApplicationException {
        ReminderAppointment appointment = null;
        if (context instanceof ReminderAppointment) {
            appointment = (ReminderAppointment)context;
        }
        try {
            ReminderAppointmentDialog d;
            if (appointment == null) {
                Reminder reminder = new Reminder();
                reminder.setQueue("jameica.reminder.appointment");
                appointment = new ReminderAppointment(null, reminder);
            }
            if ((appointment = (ReminderAppointment)(d = new ReminderAppointmentDialog(1, appointment)).open()) == null) {
                return;
            }
            ReminderService service = (ReminderService)Application.getBootLoader().getBootable(ReminderService.class);
            ReminderStorageProvider provider = service.getDefaultProvider();
            String uuid = appointment.getUid();
            Reminder reminder = appointment.getReminder();
            if (uuid == null) {
                uuid = provider.add(reminder);
                appointment.setUuid(uuid);
            } else {
                provider.update(uuid, reminder);
            }
        }
        catch (OperationCanceledException oce) {
            return;
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            Logger.error((String)"error while changing reminder", (Throwable)e);
            throw new ApplicationException(Application.getI18n().tr("Fehler beim Bearbeiten des Termins: {0}", e.getMessage()));
        }
    }
}

