/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.action;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.internal.parts.CertificateList;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.io.File;
import java.io.FileInputStream;
import java.security.cert.X509Certificate;
import org.eclipse.swt.widgets.FileDialog;

public class CertificateImport
implements Action {
    private static final Settings settings = new Settings(CertificateList.class);

    @Override
    public void handleAction(Object context) throws ApplicationException {
        FileDialog d = new FileDialog(GUI.getShell(), 4096);
        d.setText(Application.getI18n().tr("Bitte w\u00e4hlen Sie das zu importierende Zertifikat aus"));
        d.setFilterPath(settings.getString("lastdir", System.getProperty("user.home")));
        d.setFilterExtensions(new String[]{"*.pem;*.crt;*.cer"});
        String s = d.open();
        if (s == null || s.length() == 0) {
            return;
        }
        File f = new File(s);
        if (!(f.exists() && f.isFile() && f.canRead())) {
            throw new ApplicationException(Application.getI18n().tr("Zertifikat {0} nicht lesbar", s));
        }
        settings.setAttribute("lastdir", f.getParent());
        try {
            X509Certificate c = Application.getSSLFactory().loadCertificate(new FileInputStream(f));
            if (c == null) {
                throw new ApplicationException(Application.getI18n().tr("Zertifikat nicht lesbar"));
            }
            Application.getSSLFactory().addTrustedCertificate(c);
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (OperationCanceledException oce) {
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr(oce.getMessage()), 1));
        }
        catch (Exception e) {
            Logger.error((String)"error while importing certificate", (Throwable)e);
            throw new ApplicationException(Application.getI18n().tr("Fehler beim Importieren des Zertifikats"));
        }
    }
}

