/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.action;

import de.willuhn.jameica.bookmark.Bookmark;
import de.willuhn.jameica.bookmark.ContextSerializer;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;

public class BookmarkOpen
implements Action {
    @Override
    public void handleAction(Object context) throws ApplicationException {
        if (!(context instanceof Bookmark)) {
            throw new ApplicationException(Application.getI18n().tr("Bitte w\u00e4hlen Sie das zu \u00f6ffnende Lesezeichen aus"));
        }
        try {
            Bookmark b = (Bookmark)context;
            BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            ContextSerializer serializer = service.get(ContextSerializer.class);
            Object ctx = serializer.unserialize(b.getContext());
            GUI.startView(b.getView(), ctx);
        }
        catch (OperationCanceledException oce) {
            throw oce;
        }
        catch (Exception e) {
            Logger.error((String)"unable to open bookmark", (Throwable)e);
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Fehler beim \u00d6ffnen des Lesezeichens: {0}", e.getMessage()), 1));
        }
    }
}

