/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.action;

import de.willuhn.jameica.attachment.Attachment;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.services.AttachmentService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.io.File;
import org.eclipse.swt.widgets.DirectoryDialog;

public class AttachmentSave
implements Action {
    private static final I18N i18n = Application.getI18n();
    private static final Settings settings = new Settings(AttachmentSave.class);
    private AttachmentService service = (AttachmentService)Application.getBootLoader().getBootable(AttachmentService.class);

    @Override
    public void handleAction(Object context) throws ApplicationException {
        Attachment[] list = null;
        if (context instanceof Attachment) {
            list = new Attachment[]{(Attachment)context};
        } else if (context instanceof Attachment[]) {
            list = (Attachment[])context;
        }
        if (list == null || list.length == 0) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie die zu speichernden Dateien."));
        }
        String text = list.length == 1 ? "Bitte w\u00e4hlen Sie den Ordner, in dem Sie die Datei speichern wollen." : "Bitte w\u00e4hlen Sie den Ordner, in dem Sie die Dateien speichern wollen.";
        DirectoryDialog d = new DirectoryDialog(GUI.getShell());
        d.setText(i18n.tr(text));
        d.setFilterPath(settings.getString("lastdir", System.getProperty("user.home")));
        String s = d.open();
        if (s == null) {
            throw new OperationCanceledException();
        }
        File dir = new File(s);
        if (!dir.exists() && !dir.canWrite()) {
            throw new ApplicationException(i18n.tr("Sie besitzen keine Schreibrechte im ausgew\u00e4hlten Ordner."));
        }
        settings.setAttribute("lastdir", s);
        int success = 0;
        int fail = 0;
        Logger.info((String)("saving attachments to " + dir));
        for (Attachment a : list) {
            try {
                boolean overwrite;
                File target = new File(dir, a.getFilename());
                if (target.exists() && !(overwrite = Application.getCallback().askUser(i18n.tr("Datei \"{0}\" existiert bereits. \u00dcberschreiben?"), new String[]{target.getName()}, true))) continue;
                this.service.save(a, target);
                ++success;
            }
            catch (Exception e) {
                Logger.error((String)("unable to save attachment " + a.getFilename()), (Throwable)e);
                ++fail;
            }
        }
        Logger.info((String)("saved attachments - sucess: " + success + ", failed: " + fail));
        if (fail > 0) {
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(i18n.tr("Gespeicherte Dateien: {0}, fehlerhaft: {1}", new String[]{Integer.toString(success), Integer.toString(fail)}), 2));
        } else {
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(i18n.tr("Gespeicherte Dateien: {0}", Integer.toString(success)), 0));
        }
    }
}

