/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.input;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.AbstractInput;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class TextInput
extends AbstractInput {
    protected Text text;
    private String value;
    private String hint;
    private boolean enabled = true;
    private boolean focus = false;
    private int maxLength = 0;

    public TextInput(String value) {
        this(value, 0);
    }

    public TextInput(String value, int maxLength) {
        this(value, maxLength, null);
    }

    public TextInput(String value, int maxLength, String hint) {
        this.value = value;
        this.maxLength = maxLength;
        this.hint = hint;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        if (this.text != null && !this.text.isDisposed()) {
            this.text.setTextLimit(this.maxLength);
        }
    }

    public void setHint(String hint) {
        this.hint = hint;
        if (this.hint != null && this.text != null && !this.text.isDisposed()) {
            this.text.setMessage(this.hint);
        }
    }

    public String getHint() {
        return this.hint;
    }

    protected Text getTextWidget() {
        if (this.text == null) {
            this.text = GUI.getStyleFactory().createText(this.getParent());
        }
        return this.text;
    }

    @Override
    public Control getControl() {
        if (this.text != null) {
            return this.text;
        }
        this.text = this.getTextWidget();
        if (this.maxLength > 0) {
            this.text.setTextLimit(this.maxLength);
        }
        if (this.hint != null) {
            this.text.setMessage(this.hint);
        }
        this.setEnabledInternal(this.enabled);
        this.text.setText(this.value == null ? "" : this.value);
        Object tooltip = this.getData("datakey.tooltip");
        if (tooltip != null) {
            this.text.setToolTipText(tooltip.toString());
        }
        if (this.focus) {
            this.text.setFocus();
        }
        return this.text;
    }

    @Override
    public Object getValue() {
        if (this.text == null || this.text.isDisposed()) {
            return this.value;
        }
        return this.text.getText();
    }

    @Override
    public void setValue(Object value) {
        String s;
        this.value = s = value == null ? null : value.toString();
        if (this.text != null && !this.text.isDisposed()) {
            this.text.setText(s == null ? "" : s);
            this.text.redraw();
        }
    }

    @Override
    public void focus() {
        this.focus = true;
        if (this.text != null && !this.text.isDisposed()) {
            this.text.setFocus();
        }
    }

    @Override
    public void disable() {
        this.setEnabled(false);
    }

    @Override
    public void enable() {
        this.setEnabled(true);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.text != null && !this.text.isDisposed()) {
            this.setEnabledInternal(enabled);
            this.update();
        }
    }

    private void setEnabledInternal(boolean enabled) {
        int style = this.text.getStyle();
        if ((style & 0x200) != 0 || (style & 0x100) != 0) {
            this.text.setEditable(enabled);
        } else {
            this.text.setEnabled(enabled);
        }
    }
}

