/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.input;

import de.willuhn.jameica.gui.input.AbstractInput;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;

public class SpinnerInput
extends AbstractInput {
    private boolean enabled = true;
    private boolean focus = false;
    private Spinner spinner = null;
    private int min;
    private int max;
    private int value;

    public SpinnerInput(int min, int max, int value) {
        this.min = min;
        this.max = max;
        this.value = value;
    }

    @Override
    public void disable() {
        this.setEnabled(false);
    }

    @Override
    public void enable() {
        this.setEnabled(true);
    }

    @Override
    public void focus() {
        this.focus = true;
        if (this.spinner != null && !this.spinner.isDisposed()) {
            this.spinner.setFocus();
        }
    }

    @Override
    public Control getControl() {
        if (this.spinner != null && !this.spinner.isDisposed()) {
            return this.spinner;
        }
        this.spinner = new Spinner(this.getParent(), 2048);
        this.spinner.setMinimum(this.min);
        this.spinner.setMaximum(this.max);
        this.spinner.setSelection(this.value);
        this.spinner.setIncrement(1);
        this.spinner.setEnabled(this.enabled);
        Object tooltip = this.getData("datakey.tooltip");
        if (tooltip != null) {
            this.spinner.setToolTipText(tooltip.toString());
        }
        if (this.focus) {
            this.spinner.setFocus();
        }
        return this.spinner;
    }

    @Override
    public Object getValue() {
        if (this.spinner == null || this.spinner.isDisposed()) {
            return this.value;
        }
        return this.spinner.getSelection();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.spinner != null && !this.spinner.isDisposed()) {
            this.spinner.setEnabled(this.enabled);
        }
    }

    @Override
    public void setValue(Object value) {
        if (value == null || !(value instanceof Integer)) {
            return;
        }
        this.value = (Integer)value;
        if (this.spinner != null && !this.spinner.isDisposed()) {
            this.spinner.setSelection(this.value);
            this.update();
        }
    }
}

