/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.input;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.pseudo.PseudoIterator;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.AbstractInput;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class SelectInput
extends AbstractInput {
    private List list = null;
    private Object preselected = null;
    private String attribute = null;
    private Combo combo = null;
    private boolean enabled = true;
    private boolean editable = false;
    private String pleaseChoose = null;

    @Deprecated
    public SelectInput(GenericIterator list, GenericObject preselected) throws RemoteException {
        this(list != null ? PseudoIterator.asList((GenericIterator)list) : null, (Object)preselected);
    }

    public SelectInput(Object[] list, Object preselected) {
        this(list != null ? Arrays.asList(list) : null, preselected);
    }

    public SelectInput(List list, Object preselected) {
        this.list = list;
        this.preselected = preselected;
    }

    public void setPreselected(Object preselected) {
        this.preselected = preselected;
        if (this.combo == null || this.combo.isDisposed() || this.list == null) {
            return;
        }
        if (this.preselected == null) {
            this.combo.select(0);
        }
        boolean havePleaseChoose = this.pleaseChoose != null && this.pleaseChoose.length() > 0;
        int size = this.list.size();
        for (int i = 0; i < size; ++i) {
            int pos = havePleaseChoose ? i + 1 : i;
            Object value = this.combo.getData(Integer.toString(pos));
            if (value == null) continue;
            try {
                if (!BeanUtil.equals((Object)preselected, (Object)value)) continue;
                this.combo.select(pos);
                return;
            }
            catch (RemoteException re) {
                Logger.error((String)"unable to compare objects", (Throwable)re);
                return;
            }
        }
    }

    public void setPleaseChoose(String choose) {
        this.pleaseChoose = choose;
    }

    @Override
    protected void addListener(Widget w, Listener l) {
        w.addListener(13, l);
    }

    public void setAttribute(String name) {
        if (name != null) {
            this.attribute = name;
        }
    }

    @Override
    public Control getControl() {
        if (this.combo != null) {
            return this.combo;
        }
        this.combo = GUI.getStyleFactory().createCombo(this.getParent(), this.editable ? 0 : 8);
        this.combo.setVisibleItemCount(15);
        this.combo.setEnabled(this.enabled);
        Object tooltip = this.getData("datakey.tooltip");
        if (tooltip != null) {
            this.combo.setToolTipText(tooltip.toString());
        }
        this.applyList();
        return this.combo;
    }

    private void applyList() {
        if (this.combo == null || this.combo.isDisposed()) {
            return;
        }
        this.combo.removeAll();
        int selected = -1;
        boolean havePleaseChoose = false;
        if (this.pleaseChoose != null && this.pleaseChoose.length() > 0) {
            this.combo.add(this.pleaseChoose);
            havePleaseChoose = true;
        }
        if (this.list != null) {
            try {
                int size = this.list.size();
                for (int i = 0; i < size; ++i) {
                    String text;
                    Object object = this.list.get(i);
                    if (object == null || (text = this.format(object)) == null) continue;
                    this.combo.add(text);
                    this.combo.setData(Integer.toString(havePleaseChoose ? i + 1 : i), object);
                    if (selected != -1 || this.preselected == null || !BeanUtil.equals(object, (Object)this.preselected)) continue;
                    selected = i;
                    if (!havePleaseChoose) continue;
                    ++selected;
                }
            }
            catch (RemoteException e) {
                this.combo.removeAll();
                this.combo.add(Application.getI18n().tr("Fehler beim Laden der Daten..."));
                Logger.error((String)"unable to create combo box", (Throwable)e);
            }
        }
        this.combo.select(selected > -1 ? selected : 0);
        if (this.editable && this.preselected != null && !this.list.contains(this.preselected) && this.preselected instanceof String) {
            this.combo.setText((String)this.preselected);
        }
    }

    public void setList(List list) {
        this.list = list;
        this.applyList();
    }

    public List getList() {
        return this.list;
    }

    protected String format(Object bean) {
        if (bean == null) {
            return null;
        }
        try {
            if (this.attribute == null || this.attribute.length() == 0) {
                return BeanUtil.toString((Object)bean);
            }
            Object value = BeanUtil.get((Object)bean, (String)this.attribute);
            return value == null ? null : value.toString();
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to format object", (Throwable)re);
            return null;
        }
    }

    @Override
    public Object getValue() {
        if (this.combo == null || this.combo.isDisposed()) {
            return this.preselected;
        }
        if (this.editable) {
            return this.combo.getText();
        }
        int selected = this.combo.getSelectionIndex();
        if (selected == -1) {
            return null;
        }
        return this.combo.getData(Integer.toString(selected));
    }

    public String getText() {
        if (this.combo == null || this.combo.isDisposed()) {
            return null;
        }
        return this.combo.getText();
    }

    @Override
    public void focus() {
        if (this.combo == null || this.combo.isDisposed()) {
            return;
        }
        this.combo.setFocus();
    }

    @Override
    public void disable() {
        this.setEnabled(false);
    }

    @Override
    public void enable() {
        this.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.combo != null && !this.combo.isDisposed()) {
            this.combo.setEnabled(enabled);
        }
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    public void setValue(Object o) {
        this.setPreselected(o);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }
}

