/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.input;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.util.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class MultiInput
implements Input {
    public static final String DATA_WEIGHT = "jameica.multiinput.weight";
    private Map<String, Object> data = new HashMap<String, Object>();
    private List<Input> inputs = new ArrayList<Input>();
    private Composite composite = null;
    private String name = null;
    private String comment = null;
    private Label commentLabel = null;

    public MultiInput() {
    }

    public MultiInput(Input ... inputs) {
        if (inputs != null && inputs.length > 0) {
            for (Input i : inputs) {
                this.add(i);
            }
        }
    }

    public void add(Input i) {
        this.inputs.add(i);
    }

    @Override
    public void disable() {
        this.setEnabled(false);
    }

    @Override
    public void enable() {
        this.setEnabled(true);
    }

    @Override
    public void focus() {
        if (this.inputs.size() > 0) {
            this.inputs.get(0).focus();
        }
    }

    @Override
    public void addListener(Listener l) {
        for (Input i : this.inputs) {
            i.addListener(l);
        }
    }

    @Override
    public boolean hasChanged() {
        for (Input i : this.inputs) {
            if (!i.hasChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMandatory() {
        for (Input i : this.inputs) {
            if (!i.isMandatory()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setMandatory(boolean mandatory) {
        for (Input i : this.inputs) {
            i.setMandatory(mandatory);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
        if (this.commentLabel != null && !this.commentLabel.isDisposed() && this.comment != null) {
            this.commentLabel.setText(this.comment);
            this.commentLabel.redraw();
        }
    }

    @Override
    public void paint(Composite parent) {
        this.paint(parent, 240);
    }

    @Override
    public void paint(Composite parent, int width) {
        int size = this.inputs.size();
        if (this.comment != null) {
            ++size;
        }
        for (Input i : this.inputs) {
            String name = i.getName();
            if (name == null) continue;
            ++size;
        }
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(size, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 0;
        this.composite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.widthHint = width;
        this.composite.setLayoutData((Object)gd);
        for (Input i : this.inputs) {
            String name = i.getName();
            if (name != null && !(i instanceof CheckboxInput)) {
                Label l = GUI.getStyleFactory().createLabel(this.composite, 0);
                l.setText(name);
                l.setAlignment(131072);
                l.setLayoutData((Object)new GridData(68));
            }
            Number weightHint = (Number)i.getData(DATA_WEIGHT);
            int len = width / size + 2;
            if (weightHint != null) {
                i.paint(this.composite, (int)((double)len * weightHint.doubleValue()));
                continue;
            }
            i.paint(this.composite, len);
        }
        if (this.comment != null) {
            this.commentLabel = GUI.getStyleFactory().createLabel(this.composite, 0);
            this.commentLabel.setText(this.comment);
            this.commentLabel.setForeground(Color.COMMENT.getSWTColor());
            this.commentLabel.setAlignment(16384);
            this.commentLabel.setLayoutData((Object)new GridData(768));
        }
    }

    @Override
    public final Control getControl() {
        return this.composite;
    }

    @Override
    public Object getValue() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Input i : this.inputs) {
            values.add(i.getValue());
        }
        return values;
    }

    @Override
    public boolean isEnabled() {
        for (Input i : this.inputs) {
            if (i.isEnabled()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (Input i : this.inputs) {
            i.setEnabled(enabled);
        }
    }

    @Override
    public void setValue(Object value) {
        if (this.inputs.size() == 0) {
            return;
        }
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            for (int i = 0; i < values.length; ++i) {
                if (i >= this.inputs.size()) {
                    return;
                }
                this.inputs.get(i).setValue(values[i]);
            }
        } else if (value instanceof List) {
            List values = (List)value;
            for (int i = 0; i < values.size(); ++i) {
                if (i >= this.inputs.size()) {
                    return;
                }
                this.inputs.get(i).setValue(values.get(i));
            }
        } else {
            this.inputs.get(0).setValue(value);
        }
    }

    @Override
    public void setData(String key, Object data) {
        this.data.put(key, data);
    }

    @Override
    public Object getData(String key) {
        return this.data.get(key);
    }
}

