/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.input;

import de.willuhn.jameica.gui.input.AbstractInput;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.system.OperationCanceledException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;

public class LinkInput
extends AbstractInput {
    private Link link = null;
    private String text = null;
    private boolean focus = false;
    private boolean enabled = true;
    private List<Listener> listeners = new ArrayList<Listener>();

    public LinkInput(String text) {
        this.text = text;
    }

    @Override
    public Control getControl() {
        if (this.link != null) {
            return this.link;
        }
        this.link = new Link(this.getParent(), 0);
        Object tooltip = this.getData("datakey.tooltip");
        if (tooltip != null) {
            this.link.setToolTipText(tooltip.toString());
        }
        this.link.setText(this.text == null ? "" : SWTUtil.escapeLabel(this.text));
        if (this.focus) {
            this.link.setFocus();
        }
        this.link.setEnabled(this.enabled);
        for (Listener listener : this.listeners) {
            this.link.addListener(13, listener);
        }
        return this.link;
    }

    @Override
    public Object getValue() {
        return this.text;
    }

    @Override
    public void focus() {
        this.focus = true;
        if (this.link != null && !this.link.isDisposed()) {
            this.link.setFocus();
        }
    }

    @Override
    public void setValue(Object value) {
        String string = this.text = value != null ? value.toString() : "";
        if (this.link != null && !this.link.isDisposed()) {
            this.link.setText(SWTUtil.escapeLabel(this.text));
        }
    }

    @Override
    public void disable() {
        this.setEnabled(false);
    }

    @Override
    public void enable() {
        this.setEnabled(true);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.link != null && !this.link.isDisposed()) {
            this.link.setEnabled(this.enabled);
        }
    }

    @Override
    public void addListener(Listener l) {
        this.listeners.add(l);
    }

    @Override
    protected void update() throws OperationCanceledException {
    }
}

