/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.input;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.AbstractInput;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.system.OperationCanceledException;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class LabelInput
extends AbstractInput {
    private Label label;
    private String value;
    private Color color;

    public LabelInput(String value) {
        this.value = value;
    }

    @Override
    public Control getControl() {
        this.label = GUI.getStyleFactory().createLabel(this.getParent(), 0);
        Object tooltip = this.getData("datakey.tooltip");
        if (tooltip != null) {
            this.label.setToolTipText(tooltip.toString());
        }
        this.label.setText(this.value == null ? "" : SWTUtil.escapeLabel(this.value));
        if (this.color != null) {
            this.label.setForeground(this.color.getSWTColor());
        }
        return this.label;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void focus() {
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            return;
        }
        this.value = (String)value;
        if (this.label != null && !this.label.isDisposed()) {
            this.label.setText(SWTUtil.escapeLabel(value.toString()));
            this.label.redraw();
        }
    }

    public void setColor(Color color) {
        this.color = color;
        if (this.label != null && !this.label.isDisposed()) {
            this.label.setForeground(this.color.getSWTColor());
        }
    }

    @Override
    public void disable() {
    }

    @Override
    public void enable() {
    }

    @Override
    public boolean isEnabled() {
        return false;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    protected void update() throws OperationCanceledException {
    }
}

