/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.input;

import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.logging.Logger;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class IntegerInput
extends TextInput {
    public IntegerInput() {
        super("");
    }

    public IntegerInput(int value) {
        super((String)(value < 0 ? "" : "" + value));
    }

    @Override
    public Control getControl() {
        Control c = super.getControl();
        this.text.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                char[] chars = e.text.toCharArray();
                for (int i = 0; i < chars.length; ++i) {
                    if ('0' <= chars[i] && chars[i] <= '9') continue;
                    e.doit = false;
                    return;
                }
            }
        });
        return c;
    }

    @Override
    public Object getValue() {
        Object value = super.getValue();
        if (value == null || value.toString().length() == 0) {
            return null;
        }
        try {
            return Integer.valueOf(value.toString());
        }
        catch (NumberFormatException e) {
            Logger.error((String)"error while parsing from int input", (Throwable)e);
            return null;
        }
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            return;
        }
        if (!(value instanceof Integer)) {
            return;
        }
        super.setValue(value);
    }
}

