/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.input;

import de.willuhn.io.IOUtil;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.AbstractInput;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class ImageInput
extends AbstractInput {
    private static final Settings settings = new Settings(ImageInput.class);
    private byte[] data = null;
    private boolean focus = false;
    private boolean enabled = true;
    private boolean hasComment = false;
    private Button button = null;
    private MenuItem menudel = null;
    private MenuItem menucpy = null;
    private int height = 80;
    private int width = 80;
    private int border = 10;
    private boolean scale = true;

    public ImageInput(byte[] image) {
        this(image, -1, -1);
    }

    public ImageInput(byte[] image, int width, int height) {
        this.data = image;
        this.setName(i18n.tr("Bild"));
        if (width > 0) {
            this.width = width;
        }
        if (height > 0) {
            this.height = height;
        }
    }

    public void setBorder(int border) {
        if (border >= 0) {
            this.border = border;
        }
    }

    public void setScale(boolean scale) {
        this.scale = scale;
    }

    @Override
    public void disable() {
        this.setEnabled(false);
    }

    @Override
    public void enable() {
        this.setEnabled(true);
    }

    @Override
    public void focus() {
        this.focus = true;
        if (this.button != null && !this.button.isDisposed()) {
            this.button.setFocus();
        }
    }

    @Override
    public Control getControl() {
        if (this.button != null) {
            return this.button;
        }
        this.button = GUI.getStyleFactory().createButton(this.getParent());
        Object tooltip = this.getData("datakey.tooltip");
        if (tooltip != null) {
            this.button.setToolTipText(tooltip.toString());
        }
        this.button.setEnabled(this.enabled);
        if (this.focus) {
            this.button.setFocus();
        }
        GridData gd = new GridData(1);
        gd.widthHint = this.width;
        gd.heightHint = this.height;
        gd.horizontalSpan = this.hasComment ? 1 : 2;
        this.button.setLayoutData((Object)gd);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void widgetSelected(SelectionEvent e) {
                String s;
                FileDialog dialog = new FileDialog(GUI.getShell(), 4096);
                dialog.setFilterExtensions(new String[]{"*.jpg;*.jpeg;*.png;*.gif;*.bmp"});
                dialog.setText(AbstractInput.i18n.tr("Bitte w\u00e4hlen Sie die Bild-Datei aus"));
                String lastDir = settings.getString("lastdir", System.getProperty("user.home"));
                if (lastDir != null) {
                    dialog.setFilterPath(lastDir);
                }
                if ((s = dialog.open()) == null) {
                    return;
                }
                File file = new File(s);
                if (!file.exists() || !file.canRead()) {
                    Logger.warn((String)("file " + file + " not found or not readable"));
                    Application.getMessagingFactory().sendMessage(new StatusBarMessage(AbstractInput.i18n.tr("Datei {0} nicht lesbar", file.getName()), 1));
                    return;
                }
                settings.setAttribute("lastdir", file.getParent());
                int count = 0;
                byte[] buf = new byte[4096];
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                BufferedInputStream is = null;
                try {
                    is = new BufferedInputStream(new FileInputStream(file));
                    while ((count = ((InputStream)is).read(buf)) != -1) {
                        if (count <= 0) continue;
                        bos.write(buf, 0, count);
                    }
                    ImageInput.this.data = bos.toByteArray();
                    ImageInput.this.refreshImage();
                }
                catch (Exception ex) {
                    try {
                        Logger.error((String)"error while reading image", (Throwable)ex);
                        Application.getMessagingFactory().sendMessage(new StatusBarMessage(AbstractInput.i18n.tr("Datei {0} nicht lesbar: {1}", new String[]{file.getName(), ex.getMessage()}), 1));
                    }
                    catch (Throwable throwable) {
                        IOUtil.close((Closeable[])new Closeable[]{is});
                        throw throwable;
                    }
                    IOUtil.close((Closeable[])new Closeable[]{is});
                }
                IOUtil.close((Closeable[])new Closeable[]{is});
            }
        });
        Menu m = new Menu((Decorations)this.getParent().getShell(), 8);
        this.menudel = new MenuItem(m, 64);
        this.menudel.setText(i18n.tr("Bild entfernen"));
        this.menudel.setEnabled(this.data != null);
        this.menudel.setImage(SWTUtil.getImage("user-trash-full.png"));
        this.menudel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageInput.this.data = null;
                ImageInput.this.refreshImage();
            }
        });
        this.menucpy = new MenuItem(m, 64);
        this.menucpy.setText(i18n.tr("In Zwischenablage kopieren"));
        this.menucpy.setEnabled(this.data != null);
        this.menucpy.setImage(SWTUtil.getImage("edit-copy.png"));
        this.menucpy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                ClipImage ci = new ClipImage(ImageInput.this.data);
                clipboard.setContents(ci, null);
                ImageInput.this.refreshImage();
            }
        });
        this.button.setMenu(m);
        this.refreshImage();
        return this.button;
    }

    @Override
    public void setComment(String comment) {
        super.setComment(comment);
        this.hasComment = comment != null;
    }

    @Override
    protected void update() {
    }

    @Override
    public Object getValue() {
        return this.data;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.button != null && !this.button.isDisposed()) {
            this.button.setEnabled(enabled);
            this.update();
        }
    }

    @Override
    public void setValue(Object value) {
        if (value != null && !(value instanceof byte[])) {
            Logger.warn((String)("invalid data given (" + value + "), need byte[]"));
            return;
        }
        this.data = (byte[])value;
        this.refreshImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshImage() {
        if (this.button == null || this.button.isDisposed()) {
            return;
        }
        if (this.menudel != null && !this.menudel.isDisposed()) {
            this.menudel.setEnabled(this.data != null);
        }
        if (this.menucpy != null && !this.menucpy.isDisposed()) {
            this.menucpy.setEnabled(this.data != null);
        }
        if (this.data == null) {
            this.button.setImage(null);
            this.button.setText(i18n.tr("Kein Bild"));
            return;
        }
        Image image = null;
        GC gc = null;
        try {
            image = new Image((Device)GUI.getDisplay(), (InputStream)new ByteArrayInputStream(this.data));
            if (this.scale) {
                Rectangle r = image.getBounds();
                double w = (double)r.width / (double)(this.width - this.border);
                double h = (double)r.height / (double)(this.height - this.border);
                if (w > h) {
                    h = (double)r.height / w;
                    w = this.width - this.border;
                } else {
                    w = (double)r.width / h;
                    h = this.height - this.border;
                }
                Image scaled = new Image((Device)GUI.getDisplay(), this.width - this.border, this.height - this.border);
                gc = new GC((Drawable)scaled);
                gc.setAntialias(1);
                gc.setInterpolation(2);
                Rectangle source = image.getBounds();
                gc.drawImage(image, 0, 0, source.width, source.height, 0, 0, (int)w, (int)h);
                gc.dispose();
                this.button.setImage(scaled);
            } else {
                this.button.setImage(image);
            }
            this.button.setText("");
        }
        catch (Throwable t) {
            Logger.write((Level)Level.INFO, (String)"no valid image choosen", (Throwable)t);
            this.data = null;
            this.refreshImage();
        }
        finally {
            if (image != null && this.scale) {
                try {
                    image.dispose();
                }
                catch (Exception r) {}
            }
            if (gc != null) {
                try {
                    gc.dispose();
                }
                catch (Exception r) {}
            }
        }
    }

    private class ClipImage
    implements Transferable,
    ClipboardOwner {
        private byte[] image;

        public ClipImage(byte[] im) {
            this.image = im;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.imageFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return Toolkit.getDefaultToolkit().createImage(this.image);
        }

        @Override
        public void lostOwnership(Clipboard clip, Transferable tr) {
        }
    }
}

