/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.input;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.ButtonInput;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Listener;

public class FontInput
extends ButtonInput {
    private CLabel label;
    private Font font;

    public FontInput(Font font) {
        this.font = font;
        this.addButtonListener(new Listener(){

            public void handleEvent(Event event) {
                Logger.debug((String)"starting font choose dialog");
                FontDialog fd = new FontDialog(GUI.getShell());
                fd.setText(Application.getI18n().tr("Schriftauswahl"));
                FontData f = fd.open();
                if (f == null) {
                    return;
                }
                FontInput.this.setValue(new Font((Device)GUI.getDisplay(), f));
                FontInput.this.label.forceFocus();
            }
        });
    }

    @Override
    public Control getClientControl(Composite parent) {
        this.label = new CLabel(parent, 0);
        this.label.setText(this.getDemoText());
        this.label.setFont(this.font);
        return this.label;
    }

    private String getDemoText() {
        FontData[] data;
        if (this.font != null && (data = this.font.getFontData()) != null && data.length > 0 && data[0] != null && data[0].getName() != null && data[0].getName().length() > 0) {
            String stil = Application.getI18n().tr("normal");
            switch (data[0].getStyle()) {
                case 1: {
                    stil = Application.getI18n().tr("fett");
                    break;
                }
                case 2: {
                    stil = Application.getI18n().tr("kursiv");
                    break;
                }
                case 3: {
                    stil = Application.getI18n().tr("fett,kursiv");
                }
            }
            return Application.getI18n().tr("{0}, {1} Punkt, {2}", new String[]{data[0].getName(), Integer.toString(data[0].getHeight()), stil});
        }
        return "ABCDEFabcdef";
    }

    @Override
    public Object getValue() {
        return this.font;
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Font) {
            this.font = (Font)value;
            this.label.setFont(this.font);
            this.label.setText(this.getDemoText());
            this.label.redraw();
        }
    }
}

