/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.input;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.ButtonInput;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import java.io.File;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class FileInput
extends ButtonInput {
    private Text text;

    public FileInput(String file) {
        this(file, false);
    }

    public FileInput(String file, boolean save) {
        this(file, save, null);
    }

    public FileInput(String file, final boolean save, final String[] extensions) {
        this.value = file;
        this.addButtonListener(new Listener(){

            public void handleEvent(Event event) {
                Logger.debug((String)"starting file dialog");
                FileDialog dialog = new FileDialog(GUI.getShell(), save ? 8192 : 4096);
                if (extensions != null && extensions.length > 0) {
                    dialog.setFilterExtensions(extensions);
                }
                dialog.setText(Application.getI18n().tr("Bitte w\u00e4hlen Sie die Datei aus"));
                try {
                    if (FileInput.this.value != null) {
                        File f = new File(FileInput.this.value);
                        dialog.setFileName(f.getName());
                        dialog.setFilterPath(f.getParent());
                    }
                }
                catch (Exception e) {
                    Logger.error((String)"unable to parse path", (Throwable)e);
                    dialog.setFileName(FileInput.this.value);
                }
                FileInput.this.customize(dialog);
                FileInput.this.setValue(dialog.open());
                FileInput.this.text.forceFocus();
            }
        });
    }

    protected void customize(FileDialog fd) {
    }

    @Override
    public Object getValue() {
        if (this.text == null || this.text.isDisposed()) {
            return this.value;
        }
        return this.text.getText();
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            return;
        }
        if (!(value instanceof String) && !(value instanceof File)) {
            return;
        }
        this.value = value.toString();
        if (this.text != null && !this.text.isDisposed()) {
            this.text.setText((String)value);
            this.text.redraw();
        }
    }

    @Override
    public Control getClientControl(Composite parent) {
        if (this.text != null && !this.text.isDisposed()) {
            return this.text;
        }
        this.text = GUI.getStyleFactory().createText(parent);
        this.text.setText(this.value == null ? "" : this.value);
        return this.text;
    }
}

