/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.input;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.ButtonInput;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class DirectoryInput
extends ButtonInput {
    private Text text;

    public DirectoryInput(String dir) {
        this.value = dir;
        this.setButtonImage(SWTUtil.getImage("folder.png"));
        this.addButtonListener(new Listener(){

            public void handleEvent(Event event) {
                Logger.debug((String)"starting dir dialog");
                DirectoryDialog dialog = new DirectoryDialog(GUI.getShell());
                dialog.setText(Application.getI18n().tr("Bitte w\u00e4hlen Sie ein Verzeichnis aus"));
                dialog.setFilterPath(DirectoryInput.this.value);
                DirectoryInput.this.setValue(dialog.open());
                DirectoryInput.this.text.forceFocus();
            }
        });
    }

    @Override
    public Object getValue() {
        if (this.text == null || this.text.isDisposed()) {
            return this.value;
        }
        return this.text.getText();
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            return;
        }
        if (!(value instanceof String)) {
            return;
        }
        this.value = (String)value;
        if (this.text != null && !this.text.isDisposed()) {
            this.text.setText((String)value);
            this.text.redraw();
        }
    }

    @Override
    public Control getClientControl(Composite parent) {
        if (this.text != null && !this.text.isDisposed()) {
            return this.text;
        }
        this.text = GUI.getStyleFactory().createText(parent);
        this.text.setText(this.value == null ? "" : this.value);
        return this.text;
    }
}

