/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.input;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.ButtonInput;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ColorInput
extends ButtonInput {
    private Text label = null;
    private Color color = null;
    private boolean forground = false;

    public ColorInput(Color color, boolean foreground) {
        this.color = color;
        this.forground = foreground;
        this.addButtonListener(new Listener(){

            public void handleEvent(Event event) {
                Logger.debug((String)"starting color choose dialog");
                ColorDialog cd = new ColorDialog(GUI.getShell());
                cd.setRGB(ColorInput.this.color.getRGB());
                cd.setText(Application.getI18n().tr("Bitte w\u00e4hlen Sie die Farbe aus"));
                ColorInput.this.setValue(cd.open());
                ColorInput.this.label.forceFocus();
            }
        });
    }

    @Override
    public Control getClientControl(Composite parent) {
        this.label = GUI.getStyleFactory().createText(parent);
        this.label.setEditable(false);
        if (this.forground) {
            this.label.setForeground(this.color);
        } else {
            this.label.setBackground(this.color);
        }
        this.label.setText("the quick brown fox jumps over the lazy dog");
        return this.label;
    }

    @Override
    public Object getValue() {
        return this.color;
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof RGB) {
            this.color = new Color((Device)GUI.getDisplay(), (RGB)value);
        } else if (value instanceof Color) {
            this.color = (Color)value;
        }
        if (this.label == null || this.label.isDisposed()) {
            return;
        }
        if (this.forground) {
            this.label.setForeground(this.color);
        } else {
            this.label.setBackground(this.color);
        }
        this.label.redraw();
    }

    @Override
    protected void update() throws OperationCanceledException {
    }
}

