/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.input.PasswordInput;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.util.ApplicationException;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Composite;

public class NewPasswordDialog
extends AbstractDialog {
    private static final int WINDOW_WIDTH = 460;
    private String text = null;
    private String userText = null;
    private String labelText = this.i18n.tr("Neues Passwort");
    private String labelText2 = this.i18n.tr("Passwort-Wiederholung");
    private String errorText = null;
    private String enteredUsername = null;
    private String enteredPassword = null;
    private LabelInput error = null;

    public NewPasswordDialog(int position) {
        super(position);
        this.setSize(460, -1);
        this.setSideImage(SWTUtil.getImage("dialog-password.png"));
    }

    public void setText(String text) {
        if (text == null) {
            return;
        }
        this.text = text;
    }

    @Override
    protected void onEscape() {
    }

    public void setUsernameText(String text) {
        this.userText = text;
    }

    public void setLabelText(String text) {
        if (text == null || text.length() == 0) {
            return;
        }
        this.labelText = text;
    }

    public void setLabel2Text(String text) {
        if (text == null || text.length() == 0) {
            return;
        }
        this.labelText2 = text;
    }

    public final void setErrorText(String text) {
        if (text == null || text.length() == 0) {
            return;
        }
        this.errorText = text;
        if (this.error != null) {
            this.error.setValue(this.errorText);
        }
    }

    @Override
    protected void paint(Composite parent) throws Exception {
        TextInput username;
        SimpleContainer container = new SimpleContainer(parent);
        if (this.text != null && this.text.length() > 0) {
            container.addText(this.text, true);
        }
        TextInput textInput = username = this.userText != null && this.userText.length() > 0 ? new TextInput(null) : null;
        if (username != null) {
            username.setValue(Application.getStartupParams().getUsername());
            username.setName(this.userText);
            username.setMandatory(true);
            username.focus();
            container.addInput(username);
        }
        final PasswordInput password = new PasswordInput(null);
        password.setName(this.labelText);
        password.setMandatory(true);
        if (username == null) {
            password.focus();
        }
        container.addInput(password);
        final PasswordInput password2 = new PasswordInput(null);
        password2.setName(this.labelText2);
        password2.setMandatory(true);
        container.addInput(password2);
        this.error = new LabelInput(null);
        this.error.setColor(Color.ERROR);
        this.error.setName("");
        this.error.setValue(this.errorText);
        container.addInput(this.error);
        ButtonArea buttons = new ButtonArea();
        buttons.addButton("    " + this.i18n.tr("OK") + "    ", new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                String p2;
                String p;
                if (username != null) {
                    String u = (String)username.getValue();
                    if (!NewPasswordDialog.this.checkUsername(u)) {
                        username.focus();
                        return;
                    }
                    NewPasswordDialog.this.enteredUsername = u;
                }
                if (!NewPasswordDialog.this.checkPassword(p = (String)password.getValue(), p2 = (String)password2.getValue())) {
                    password.focus();
                    return;
                }
                NewPasswordDialog.this.enteredPassword = p;
                NewPasswordDialog.this.close();
            }
        }, null, true, "ok.png");
        buttons.addButton(this.i18n.tr("Abbrechen"), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                throw new OperationCanceledException("Dialog abgebrochen");
            }
        }, null, false, "process-stop.png");
        container.addButtonArea(buttons);
        this.addShellListener(new ShellListener(){

            public void shellClosed(ShellEvent e) {
                throw new OperationCanceledException("dialog cancelled via close button");
            }

            public void shellActivated(ShellEvent e) {
            }

            public void shellDeactivated(ShellEvent e) {
            }

            public void shellDeiconified(ShellEvent e) {
            }

            public void shellIconified(ShellEvent e) {
            }
        });
        this.getShell().setMinimumSize(this.getShell().computeSize(460, -1));
    }

    protected boolean checkUsername(String username) {
        if (username == null || username.trim().length() == 0) {
            this.setErrorText(this.i18n.tr("Bitte geben Sie einen Namen ein."));
            return false;
        }
        if (username.trim().length() < 3) {
            this.setErrorText(this.i18n.tr("Bitte geben Sie als Name mindestens 3 Zeichen ein."));
            return false;
        }
        return true;
    }

    protected boolean checkPassword(String password, String password2) {
        boolean set;
        boolean bl = set = password != null && password.length() > 0 && password2 != null && password2.length() > 0;
        if (!set) {
            this.setErrorText(this.i18n.tr("Bitte geben Sie ein Passwort ein."));
            return false;
        }
        if (password != null && !password.equals(password2)) {
            this.setErrorText(this.i18n.tr("Die eingegebenen Passworte stimmen nicht \u00fcberein."));
            return false;
        }
        return true;
    }

    protected Object getData() throws Exception {
        return this.enteredPassword;
    }

    public String getUsername() {
        return this.enteredUsername;
    }
}

