/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.input.PasswordInput;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.Container;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.security.Login;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.util.ApplicationException;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Composite;

public class LoginDialog
extends AbstractDialog {
    private Login login = null;
    private String labelUser = null;
    private String labelPassword = null;
    private LabelInput error = null;
    private String text = null;
    private String errorText = null;

    public LoginDialog(int position) {
        super(position);
        this.setSize(400, -1);
        this.setTitle(this.i18n.tr("Login"));
        this.setSideImage(SWTUtil.getImage("dialog-password.png"));
        this.labelUser = this.i18n.tr("Benutzername");
        this.labelPassword = this.i18n.tr("Passwort");
        this.text = this.i18n.tr("Bitte geben Sie Benutzername und Passwort ein.");
    }

    public void setLogin(Login login) {
        this.login = login;
    }

    public void setUsernameLabelText(String text) {
        if (text != null && text.length() > 0) {
            this.labelUser = text;
        }
    }

    public void setPasswordLabelText(String text) {
        if (text != null && text.length() > 0) {
            this.labelPassword = text;
        }
    }

    public void setText(String text) {
        if (text != null) {
            this.text = text;
        }
    }

    public void setErrorText(String text) {
        this.errorText = text;
        if (this.error != null) {
            this.error.setValue(this.errorText == null ? "" : this.errorText);
        }
    }

    @Override
    protected void paint(Composite parent) throws Exception {
        SimpleContainer container = new SimpleContainer(parent);
        if (this.text != null && this.text.length() > 0) {
            container.addText(this.text, true);
        }
        final TextInput username = new TextInput(null);
        username.setName(this.labelUser);
        username.setMaxLength(100);
        container.addInput(username);
        final PasswordInput password = new PasswordInput(null);
        password.setName(this.labelPassword);
        password.setMaxLength(100);
        container.addInput(password);
        if (this.login != null) {
            String user = this.login.getUsername();
            username.setValue(user);
            char[] pw = this.login.getPassword();
            if (pw != null) {
                password.setValue(new String(pw));
            }
            if (user != null) {
                password.focus();
            } else {
                username.focus();
            }
        }
        this.error = new LabelInput(this.errorText);
        this.error.setColor(Color.ERROR);
        this.error.setName("");
        container.addInput(this.error);
        this.extend(container);
        ButtonArea buttons = new ButtonArea();
        buttons.addButton("    " + this.i18n.tr("OK") + "    ", new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                if (LoginDialog.this.login == null) {
                    LoginDialog.this.login = new Login();
                }
                LoginDialog.this.login.setUsername((String)username.getValue());
                LoginDialog.this.login.setPassword((String)password.getValue());
                if (LoginDialog.this.checkLogin(LoginDialog.this.login)) {
                    LoginDialog.this.close();
                }
            }
        }, null, true, "ok.png");
        buttons.addButton(this.i18n.tr("Abbrechen"), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                throw new OperationCanceledException("Dialog abgebrochen");
            }
        }, null, false, "process-stop.png");
        container.addButtonArea(buttons);
        this.addShellListener(new ShellListener(){

            public void shellClosed(ShellEvent e) {
                throw new OperationCanceledException("dialog cancelled via close button");
            }

            public void shellActivated(ShellEvent e) {
            }

            public void shellDeactivated(ShellEvent e) {
            }

            public void shellDeiconified(ShellEvent e) {
            }

            public void shellIconified(ShellEvent e) {
            }
        });
    }

    protected Object getData() throws Exception {
        return this.login;
    }

    protected void extend(Container container) throws Exception {
    }

    protected boolean checkLogin(Login login) {
        return true;
    }
}

