/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.dialogs;

import de.willuhn.jameica.gui.dialogs.LoginDialog;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.util.Container;
import de.willuhn.jameica.security.JameicaAuthenticator;
import de.willuhn.jameica.security.Login;
import de.willuhn.jameica.security.Wallet;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class HttpAuthDialog
extends LoginDialog {
    private static Wallet wallet = null;
    private static Settings settings = new Settings(HttpAuthDialog.class);
    private CheckboxInput store = null;
    private String walletKey = null;

    public HttpAuthDialog(int position) {
        this(position, null);
    }

    public HttpAuthDialog(int position, JameicaAuthenticator auth) {
        super(position);
        if (auth != null) {
            String prompt = (String)auth.getRequestParam(JameicaAuthenticator.RequestParam.PROMPT);
            String host = (String)auth.getRequestParam(JameicaAuthenticator.RequestParam.HOST);
            this.walletKey = host + ":" + auth.getRequestParam(JameicaAuthenticator.RequestParam.PORT) + ":" + prompt;
            if (prompt != null && prompt.length() > 0) {
                this.setText(this.i18n.tr("Bitte geben Sie Benutzername und Passwort ein.\nSeite: {0}", prompt));
            }
            if (host != null && host.length() > 0) {
                this.setTitle(this.i18n.tr("Login: {0}", host));
            }
            this.setLogin((Login)wallet.get(this.walletKey));
        }
        this.addCloseListener(new Listener(){

            public void handleEvent(Event event) {
                if (event.detail != 32) {
                    return;
                }
                Login login = (Login)event.data;
                try {
                    wallet.set(HttpAuthDialog.this.walletKey, settings.getBoolean("login.store", false) ? login : null);
                }
                catch (Exception e) {
                    Logger.error((String)"unable to store login in wallet", (Throwable)e);
                }
            }
        });
    }

    @Override
    protected void extend(Container container) throws Exception {
        this.store = new CheckboxInput(settings.getBoolean("login.store", false));
        this.store.addListener(new Listener(){

            public void handleEvent(Event event) {
                settings.setAttribute("login.store", (Boolean)HttpAuthDialog.this.store.getValue());
            }
        });
        container.addCheckbox(this.store, this.i18n.tr("Login speichern"));
    }

    static {
        try {
            wallet = new Wallet(HttpAuthDialog.class);
        }
        catch (Exception e) {
            Logger.error((String)"unable to create wallet, saving of logins disabled", (Throwable)e);
        }
    }
}

