/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.ProgressBar;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.BackgroundTask;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import org.eclipse.swt.widgets.Composite;

public class BackgroundTaskDialog
extends AbstractDialog {
    private static final int WINDOW_WIDTH = 500;
    private BackgroundTask task = null;
    private boolean interruptible = false;
    private Button cancel = null;

    public BackgroundTaskDialog(int position, BackgroundTask task) {
        super(position);
        this.setSize(500, -1);
        this.task = task;
    }

    public void setInterruptible(boolean b) {
        this.interruptible = b;
    }

    protected Object getData() throws Exception {
        return this.task;
    }

    @Override
    protected void paint(Composite parent) throws Exception {
        if (this.task == null) {
            throw new Exception("no task given");
        }
        final ProgressBar monitor = new ProgressBar();
        monitor.showLogs(false);
        monitor.paint(parent);
        final Thread t = new Thread("[Jameica Backgroundtask] " + this.task.getClass().getName()){

            @Override
            public void run() {
                GUI.getStatusBar().startProgress();
                try {
                    BackgroundTaskDialog.this.task.run(monitor);
                }
                catch (OperationCanceledException oce) {
                    if (monitor != null) {
                        monitor.setStatus(5);
                        monitor.setPercentComplete(100);
                        monitor.setStatusText(oce.getMessage());
                    }
                }
                catch (ApplicationException ae) {
                    if (monitor != null) {
                        monitor.setStatus(3);
                        monitor.setPercentComplete(100);
                        monitor.setStatusText(ae.getMessage());
                    }
                    Application.getMessagingFactory().sendMessage(new StatusBarMessage(ae.getMessage(), 1));
                }
                catch (Throwable t) {
                    Logger.error((String)"error while executing background task", (Throwable)t);
                    Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Fehler: {0}", t.getMessage()), 1));
                    if (monitor != null) {
                        monitor.setStatus(3);
                        monitor.setPercentComplete(100);
                    }
                }
                finally {
                    GUI.getStatusBar().stopProgress();
                    BackgroundTaskDialog.this.close();
                }
            }
        };
        if (this.interruptible) {
            ButtonArea buttons = new ButtonArea();
            this.cancel = new Button(Application.getI18n().tr("Abbrechen"), new Action(){

                @Override
                public void handleAction(Object context) throws ApplicationException {
                    GUI.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            BackgroundTaskDialog.this.cancel.setEnabled(false);
                            monitor.setStatus(5);
                            monitor.setStatusText(Application.getI18n().tr("Breche ab ..."));
                        }
                    });
                    Thread shutdown = new Thread("[Shutdown Backgroundtask] " + BackgroundTaskDialog.this.task.getClass().getName()){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            block10: {
                                try {
                                    Logger.info((String)"interrupting background task");
                                    BackgroundTaskDialog.this.task.interrupt();
                                    Logger.info((String)"waiting for task to finish");
                                    long timeout = System.currentTimeMillis() + 60000L;
                                    while (!BackgroundTaskDialog.this.task.isInterrupted() && System.currentTimeMillis() < timeout) {
                                        try {
                                            Thread.sleep(1000L);
                                        }
                                        catch (Exception e) {
                                            Logger.error((String)"error while waiting for task", (Throwable)e);
                                            break;
                                        }
                                    }
                                    if (!t.isAlive() || t.isInterrupted()) break block10;
                                    Logger.info((String)"interrupting thread");
                                    try {
                                        t.interrupt();
                                    }
                                    catch (Exception e) {
                                        Logger.error((String)"unable to interrupt thread", (Throwable)e);
                                    }
                                    Logger.info((String)"waiting for thread to finish");
                                    t.join(60000L);
                                }
                                catch (Exception e) {
                                    Logger.error((String)"unable to stop background task", (Throwable)e);
                                }
                                finally {
                                    Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Abgebrochen"), 1));
                                }
                            }
                        }
                    };
                    shutdown.start();
                }
            }, null, false, "process-stop.png");
            buttons.addButton(this.cancel);
            SimpleContainer c = new SimpleContainer(parent);
            c.addButtonArea(buttons);
        }
        this.getShell().setMinimumSize(this.getShell().computeSize(500, -1));
        Runnable job = new Runnable(){

            @Override
            public void run() {
                t.start();
            }
        };
        this.getDisplay().asyncExec(job);
    }
}

