/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.calendar;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.calendar.AppointmentProvider;
import de.willuhn.jameica.gui.calendar.CalendarPart;
import de.willuhn.jameica.gui.calendar.ReminderAppointmentProvider;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import java.rmi.RemoteException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;

public class ReminderCalendarPart
extends CalendarPart {
    private AppointmentProvider myProvider = null;

    public ReminderCalendarPart() {
        BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        this.myProvider = service.get(ReminderAppointmentProvider.class);
        this.addAppointmentProvider(this.myProvider);
    }

    @Override
    public void paint(Composite parent) throws RemoteException {
        super.paint(parent);
        final MyMessageConsumer mc = new MyMessageConsumer();
        Application.getMessagingFactory().getMessagingQueue("jameica.reminder.added").registerMessageConsumer(mc);
        Application.getMessagingFactory().getMessagingQueue("jameica.reminder.updated").registerMessageConsumer(mc);
        Application.getMessagingFactory().getMessagingQueue("jameica.reminder.deleted").registerMessageConsumer(mc);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Application.getMessagingFactory().getMessagingQueue("jameica.reminder.added").unRegisterMessageConsumer(mc);
                Application.getMessagingFactory().getMessagingQueue("jameica.reminder.updated").unRegisterMessageConsumer(mc);
                Application.getMessagingFactory().getMessagingQueue("jameica.reminder.deleted").unRegisterMessageConsumer(mc);
            }
        });
    }

    @Override
    public void removeAppointmentProvider(AppointmentProvider provider) {
        if (provider == null || provider.getClass().equals(this.myProvider.getClass())) {
            return;
        }
        super.removeAppointmentProvider(provider);
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.addAppointmentProvider(this.myProvider);
    }

    private class MyMessageConsumer
    implements MessageConsumer {
        private MyMessageConsumer() {
        }

        @Override
        public boolean autoRegister() {
            return false;
        }

        @Override
        public Class[] getExpectedMessageTypes() {
            return new Class[]{QueryMessage.class};
        }

        @Override
        public void handleMessage(Message message) throws Exception {
            GUI.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    ReminderCalendarPart.this.refresh();
                }
            });
        }
    }
}

