/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.calendar;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.calendar.Appointment;
import de.willuhn.jameica.gui.calendar.DayRenderer;
import de.willuhn.jameica.gui.util.Font;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class DayRendererImpl
implements DayRenderer {
    private static final int[] BACKGROUNDS = new int[]{25, 31, 22, 1};
    private Map<RGB, Color> colorMap = new HashMap<RGB, Color>();
    private Composite comp = null;
    private Label day = null;
    private ScrolledComposite scroll = null;
    private Composite content = null;

    @Override
    public void paint(Composite parent) throws RemoteException {
        GridData gd = new GridData(1808);
        gd.heightHint = parent.getBounds().height / 6;
        this.comp = new Composite(parent, 0);
        this.comp.setLayoutData((Object)gd);
        this.comp.setBackground(this.getBackground());
        this.comp.setBackgroundMode(2);
        this.comp.setLayout((Layout)SWTUtil.createGrid(1, false));
        this.comp.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DayRendererImpl.this.disposeColors();
            }
        });
        this.day = new Label(this.comp, 131072);
        this.day.setLayoutData((Object)new GridData(768));
        this.scroll = new ScrolledComposite(this.comp, 512);
        this.scroll.setLayoutData((Object)new GridData(1808));
        this.scroll.setLayout((Layout)new GridLayout(1, false));
        this.scroll.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                DayRendererImpl.this.content.setSize(DayRendererImpl.this.content.computeSize(DayRendererImpl.this.scroll.getClientArea().width, -1));
            }
        });
        this.content = new Composite((Composite)this.scroll, 0);
        this.content.setLayoutData((Object)new GridData(1808));
        this.content.setLayout((Layout)new GridLayout(1, false));
        this.scroll.setContent((Control)this.content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(DayRenderer.Status status, Date date, List<Appointment> appointments) {
        SWTUtil.disposeChildren(this.content);
        try {
            if (date == null || status == DayRenderer.Status.OFF) {
                this.renderNone();
                return;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            this.day.setText(Integer.toString(cal.get(5)) + " ");
            int weekday = cal.get(7);
            Color color = status == DayRenderer.Status.CURRENT || weekday == 7 || weekday == 1 ? this.getHighlightBackground() : this.getBackground();
            this.comp.setBackground(color);
            this.content.setBackground(color);
            RGB rgb = color.getRGB();
            this.day.setBackground(this.getColor(new RGB(rgb.red - 15, rgb.green - 15, rgb.blue - 15)));
            if (appointments != null && appointments.size() > 0) {
                boolean more = appointments.size() > 2;
                for (Appointment a : appointments) {
                    if (more) {
                        this.renderLong(a);
                        continue;
                    }
                    this.renderShort(a);
                }
            }
        }
        finally {
            this.content.layout();
            this.content.setSize(this.content.computeSize(-1, -1));
        }
    }

    private void renderNone() {
        this.day.setText("");
        Color bg = de.willuhn.jameica.gui.util.Color.BACKGROUND.getSWTColor();
        this.comp.setBackground(bg);
        this.content.setBackground(bg);
        this.day.setBackground(bg);
    }

    private MouseListener createListener(final Appointment a) {
        return new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                try {
                    a.execute();
                }
                catch (ApplicationException ae) {
                    Application.getMessagingFactory().sendMessage(new StatusBarMessage(ae.getMessage(), 1));
                }
            }
        };
    }

    private void renderLong(Appointment a) {
        CLabel label = new CLabel(this.content, 16384);
        label.setFont(Font.SMALL.getSWTFont());
        try {
            label.setMargins(0, 0, 0, 0);
        }
        catch (NoSuchMethodError e) {
            Logger.write((Level)Level.DEBUG, (String)"unable to set margins, SWT version probably too old", (Throwable)e);
        }
        label.setLayoutData((Object)new GridData(768));
        label.addMouseListener(this.createListener(a));
        RGB fg = a.getColor();
        if (fg != null) {
            label.setForeground(this.getColor(fg));
        }
        String name = a.getName();
        label.setText(name);
        String desc = a.getDescription();
        if (desc == null || desc.length() == 0) {
            desc = name;
        }
        label.setToolTipText(desc);
    }

    private void renderShort(Appointment a) {
        String name;
        Label label = new Label(this.content, 16448);
        label.setFont(Font.SMALL.getSWTFont());
        label.setLayoutData((Object)new GridData(768));
        label.addMouseListener(this.createListener(a));
        RGB fg = a.getColor();
        if (fg != null) {
            label.setForeground(this.getColor(fg));
        }
        label.setText((name = a.getName()) == null ? "" : name);
        String desc = a.getDescription();
        if (desc == null || desc.length() == 0) {
            desc = name;
        }
        label.setToolTipText(desc);
    }

    protected Color getBackground() {
        Display display = GUI.getDisplay();
        for (int i : BACKGROUNDS) {
            Color c = display.getSystemColor(i);
            if (c == null) continue;
            return c;
        }
        return de.willuhn.jameica.gui.util.Color.WHITE.getSWTColor();
    }

    protected Color getHighlightBackground() {
        int b;
        int g;
        Color bg = this.getBackground();
        int r = bg.getRed();
        double avg = (r + (g = bg.getGreen()) + (b = bg.getBlue())) / 3;
        int offset = avg > 127.0 ? -15 : 40;
        return this.getColor(new RGB(r + offset, g + offset, b + offset));
    }

    private Color getColor(RGB rgb) {
        Color color = this.colorMap.get(rgb);
        if (color != null && !color.isDisposed()) {
            return color;
        }
        color = new Color((Device)GUI.getDisplay(), rgb);
        this.colorMap.put(rgb, color);
        return color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeColors() {
        Map<RGB, Color> map = this.colorMap;
        synchronized (map) {
            try {
                for (Color c : this.colorMap.values()) {
                    if (c == null || c.isDisposed()) continue;
                    c.dispose();
                }
            }
            finally {
                this.colorMap.clear();
            }
        }
    }
}

