/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.calendar;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.calendar.Appointment;
import de.willuhn.jameica.gui.calendar.AppointmentProvider;
import de.willuhn.jameica.gui.calendar.DayRenderer;
import de.willuhn.jameica.gui.calendar.DayRendererImpl;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CalendarPart
implements Part {
    private DateFormat dateformat = new SimpleDateFormat("MMMM yyyy", Application.getConfig().getLocale());
    private Date currentDate = new Date();
    private Label text = null;
    private List<DayRenderer> days = new ArrayList<DayRenderer>();
    private Class<? extends DayRenderer> renderer = DayRendererImpl.class;
    private List<AppointmentProvider> providers = new ArrayList<AppointmentProvider>();

    public void setCurrentDate(Date d) {
        if (d != null) {
            this.currentDate = d;
        }
        if (this.text != null) {
            this.refresh();
        }
    }

    public Date getCurrentDate() {
        return this.currentDate;
    }

    public void setDayRenderer(Class<? extends DayRenderer> renderer) {
        this.renderer = renderer;
    }

    public void addAppointmentProvider(AppointmentProvider provider) {
        this.providers.add(provider);
    }

    public void removeAppointmentProvider(AppointmentProvider provider) {
        this.providers.remove(provider);
    }

    public void removeAll() {
        this.providers.clear();
    }

    @Override
    public void paint(Composite parent) throws RemoteException {
        String[] weekdays;
        Composite comp = new Composite(parent, 0);
        comp.setLayoutData((Object)new GridData(1808));
        GridLayout gl = SWTUtil.createGrid(7, true);
        gl.verticalSpacing = 1;
        gl.horizontalSpacing = 1;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        comp.setLayout((Layout)gl);
        this.createPager(comp, "<<", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CalendarPart.this.move(1, -1);
            }
        });
        this.createPager(comp, "<", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CalendarPart.this.move(2, -1);
            }
        });
        this.text = new Label(comp, 0x1000000);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.text.setLayoutData((Object)gd);
        this.text.setToolTipText(Application.getI18n().tr("Klicken Sie hier, um zum aktuellen Monat zur\u00fcckzukehren."));
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                CalendarPart.this.currentDate = new Date();
                CalendarPart.this.refresh();
            }
        });
        this.createPager(comp, ">", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CalendarPart.this.move(2, 1);
            }
        });
        this.createPager(comp, ">>", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CalendarPart.this.move(1, 1);
            }
        });
        I18N i18n = Application.getI18n();
        for (String day : weekdays = new String[]{i18n.tr("Mo"), i18n.tr("Di"), i18n.tr("Mi"), i18n.tr("Do"), i18n.tr("Fr"), i18n.tr("Sa"), i18n.tr("So")}) {
            CLabel label = new CLabel(comp, 0x1000008);
            label.setLayoutData((Object)new GridData(768));
            label.setText(day);
        }
        try {
            for (int i = 0; i < 42; ++i) {
                DayRenderer day = this.renderer.newInstance();
                day.paint(comp);
                this.days.add(day);
            }
        }
        catch (Exception e) {
            throw new RemoteException("unable to load day renderer", e);
        }
        this.refresh();
    }

    private void move(int type, int value) {
        Calendar now = Calendar.getInstance();
        now.setTime(this.currentDate);
        now.add(type, value);
        this.currentDate = now.getTime();
        this.refresh();
    }

    private Map<Date, List<Appointment>> getAppointments(Date start, Date end) {
        start = DateUtil.startOfDay(start);
        end = DateUtil.endOfDay(end);
        HashMap<Date, List<Appointment>> dates = new HashMap<Date, List<Appointment>>();
        for (AppointmentProvider provider : this.providers) {
            try {
                List<Appointment> list = provider.getAppointments(start, end);
                if (list == null || list.size() == 0) continue;
                for (Appointment a : list) {
                    Date d;
                    if (a == null || (d = a.getDate()) == null) continue;
                    LinkedList<Appointment> current = (LinkedList<Appointment>)dates.get(d = DateUtil.startOfDay(d));
                    if (current == null) {
                        current = new LinkedList<Appointment>();
                        dates.put(d, current);
                    }
                    current.add(a);
                }
            }
            catch (Exception e) {
                Logger.error((String)("error while fetching appointments from " + provider.getName() + ", skipping"), (Throwable)e);
            }
        }
        return dates;
    }

    public void refresh() {
        this.text.setText(this.dateformat.format(this.currentDate));
        Calendar now = Calendar.getInstance();
        now.setTime(this.currentDate);
        int lastDay = now.getActualMaximum(5);
        now.set(5, lastDay);
        Date end = now.getTime();
        now.set(5, 1);
        Map<Date, List<Appointment>> appointments = this.getAppointments(now.getTime(), end);
        int startIndex = now.get(7) - 2;
        if (startIndex < 0) {
            startIndex = 6;
        }
        int endIndex = startIndex + lastDay - 1;
        int currentDay = 1;
        int pos = 0;
        for (DayRenderer day : this.days) {
            if (pos >= startIndex && pos <= endIndex) {
                now.set(5, currentDay);
                Date d = DateUtil.startOfDay(now.getTime());
                day.update(d.equals(DateUtil.startOfDay(new Date())) ? DayRenderer.Status.CURRENT : DayRenderer.Status.NORMAL, d, appointments.get(d));
                ++currentDay;
            } else {
                day.update(DayRenderer.Status.OFF, null, null);
            }
            ++pos;
        }
    }

    private void createPager(Composite parent, String label, SelectionListener l) {
        Button b = GUI.getStyleFactory().createButton(parent);
        b.setText(label);
        b.setLayoutData((Object)new GridData(768));
        b.addSelectionListener(l);
    }
}

