/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.boxes;

import de.willuhn.boot.BootLoader;
import de.willuhn.jameica.gui.boxes.AbstractBox;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.InfoPanel;
import de.willuhn.jameica.messaging.BootMessage;
import de.willuhn.jameica.messaging.BootMessageConsumer;
import de.willuhn.jameica.messaging.MessagingQueue;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import java.rmi.RemoteException;
import java.util.List;
import org.eclipse.swt.widgets.Composite;

public class SystemMessages
extends AbstractBox {
    @Override
    public String getName() {
        return "Jameica: " + Application.getI18n().tr("System-Meldungen");
    }

    @Override
    public boolean isActive() {
        return super.isActive() && this.getMessages().size() > 0;
    }

    @Override
    public boolean isEnabled() {
        return this.getMessages().size() > 0;
    }

    private List<BootMessage> getMessages() {
        BootLoader loader = Application.getBootLoader();
        MessagingQueue queue = Application.getMessagingFactory().getMessagingQueue("jameica.boot");
        queue.flush();
        BeanService service = (BeanService)loader.getBootable(BeanService.class);
        BootMessageConsumer consumer = service.get(BootMessageConsumer.class);
        return consumer.getMessages();
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public int getHeight() {
        int size = this.getMessages().size();
        return 120 * (size == 0 ? 1 : size);
    }

    @Override
    public boolean getDefaultEnabled() {
        return true;
    }

    @Override
    public int getDefaultIndex() {
        return 0;
    }

    @Override
    public void paint(Composite parent) throws RemoteException {
        for (BootMessage msg : this.getMessages()) {
            InfoPanel panel = new InfoPanel();
            panel.setTitle(msg.getTitle());
            panel.setText(msg.getText());
            panel.setComment(msg.getComment());
            panel.setIcon(msg.getIcon());
            panel.setUrl(msg.getUrl());
            for (Button button : msg.getButtons()) {
                panel.addButton(button);
            }
            panel.paint(parent);
        }
    }
}

