/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.boxes;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.boxes.AbstractBox;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.internal.action.RepositoryEdit;
import de.willuhn.jameica.gui.internal.action.Settings;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.InfoPanel;
import de.willuhn.jameica.services.RepositoryService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Objects;
import org.eclipse.swt.widgets.Composite;

public class PluginRepositories
extends AbstractBox {
    private static final I18N i18n = Application.getI18n();

    @Override
    public String getName() {
        return "Jameica: " + Application.getI18n().tr("Aktive Plugin-Repositories von Drittanbietern");
    }

    @Override
    public int getHeight() {
        return 260;
    }

    @Override
    public boolean isActive() {
        return this.haveExternal();
    }

    private boolean haveExternal() {
        RepositoryService service = (RepositoryService)Application.getBootLoader().getBootable(RepositoryService.class);
        return service.getRepositories().stream().anyMatch(u -> !Objects.equals(u.getHost(), "www.willuhn.de"));
    }

    @Override
    public boolean getDefaultEnabled() {
        return this.haveExternal();
    }

    @Override
    public int getDefaultIndex() {
        return 0;
    }

    @Override
    public void paint(Composite parent) throws RemoteException {
        InfoPanel panel = new InfoPanel(){

            @Override
            public Composite extend(InfoPanel.DrawState state, Composite comp, Object context) {
                if (state == InfoPanel.DrawState.COMMENT_AFTER) {
                    CheckboxInput dismiss = new CheckboxInput(false);
                    dismiss.setName(i18n.tr("Diesen Hinweis nicht mehr anzeigen"));
                    dismiss.addListener(e -> {
                        if (!((Boolean)dismiss.getValue()).booleanValue()) {
                            return;
                        }
                        try {
                            if (Application.getCallback().askUser(i18n.tr("Sind Sie sicher, dass dieser Hinweis nicht mehr angezeigt werden soll?"), false)) {
                                PluginRepositories.this.setEnabled(false);
                                GUI.getCurrentView().reload();
                            } else {
                                dismiss.setValue(false);
                            }
                        }
                        catch (Exception ex) {
                            Logger.error((String)"unable to dismiss box", (Throwable)ex);
                        }
                    });
                    dismiss.paint(comp);
                }
                return super.extend(state, comp, context);
            }
        };
        panel.setTitle(i18n.tr(i18n.tr("Hinweis zu Plugin-Repositories von Drittanbietern")));
        panel.setIcon("dialog-question-large.png");
        panel.setText(i18n.tr("Derzeit sind Plugin-Repositories von Drittanbietern aktiviert. Bei der Suche nach Updates wird Jameica diese kontaktieren und ggf. Sicherheitsabfragen f\u00fcr die Zertifikate der Server anzeigen."));
        panel.setComment(i18n.tr("Klicken Sie auf \"Repositories bearbeiten...\", um Plugin-Repositories zu deaktivieren, von denen Sie keine Plugins nutzen. Sie k\u00f6nnen diese sp\u00e4ter jederzeit wieder in \"Datei->Einstellungen->Plugins\" aktivieren"));
        panel.setUrl("https://www.willuhn.de/wiki/doku.php?id=support:faq#sicherheitsabfrage_fuer_zertifikat");
        panel.addButton(new Button(i18n.tr("Repositories bearbeiten..."), new RepositoryEdit(), null, false, "document-properties.png"));
        panel.addButton(new Button(i18n.tr("Installierte Plugins..."), new Settings(), 1, false, "emblem-package.png"));
        panel.paint(parent);
    }
}

